/*
 * Decompiled with CFR 0.152.
 */
package me.purox.scenarios.scenarios;

import java.util.ArrayList;
import java.util.List;
import me.purox.scenarios.Main;
import me.purox.scenarios.events.ScenarioDisableEvent;
import me.purox.scenarios.events.ScenarioEnabledEvent;
import me.purox.scenarios.scenarios.ScenarioManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Scenario {
    private List<String> description;
    private String name;
    private Material explanationItem;
    private boolean enabled = false;
    private Listener listener;
    Player player;

    public Scenario(String name, Material explanationItem, List<String> description, Listener listener) {
        this.description = description;
        this.name = name;
        this.explanationItem = explanationItem;
        this.listener = listener;
        ScenarioManager.getInstance().scenarioMap.put(this.name, this);
    }

    public ItemStack getExplanationItem() {
        ItemStack itemStack = new ItemStack(this.explanationItem, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.AQUA + this.name);
        ArrayList<String> lore = new ArrayList<String>();
        for (String desc : this.description) {
            lore.add(ChatColor.WHITE + desc);
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack getEditorItem() {
        ItemStack itemStack = new ItemStack(this.explanationItem, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.AQUA + this.name);
        ArrayList<String> lore = new ArrayList<String>();
        if (!this.isEnabled()) {
            lore.add(ChatColor.WHITE + "    Enabled");
            lore.add(ChatColor.DARK_GRAY + ChatColor.STRIKETHROUGH.toString() + ">>" + ChatColor.RESET.toString() + ChatColor.WHITE + " Disabled");
        } else {
            lore.add(ChatColor.DARK_GRAY + ChatColor.STRIKETHROUGH.toString() + ">>" + ChatColor.RESET.toString() + ChatColor.WHITE + " Enabled");
            lore.add(ChatColor.WHITE + "    Disabled");
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        Bukkit.broadcastMessage((String)(ChatColor.YELLOW + this.name + ChatColor.GREEN + " has been " + (!this.enabled ? "enabled" : "disabled")));
        this.enabled = enabled;
        if (enabled) {
            this.register();
        } else {
            this.unregister();
        }
    }

    public String getName() {
        return this.name;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void register() {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.DARK_AQUA + this.name + " listener has been registered");
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)Main.getPlugin());
        ScenarioEnabledEvent event = new ScenarioEnabledEvent(this, this.player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public void unregister() {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.DARK_AQUA + this.name + " listener has been unregistered");
        HandlerList.unregisterAll((Listener)this.listener);
        ScenarioDisableEvent event = new ScenarioDisableEvent(this, this.player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }
}

