/*
 * Decompiled with CFR 0.152.
 */
package me.purox.scenarios.listener.scenarios;

import me.purox.scenarios.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.inventory.ItemStack;

public class BareBonesListener
implements Listener {
    @EventHandler
    public void onPortal(PlayerPortalEvent event) {
        event.setCancelled(true);
        event.getPlayer().sendMessage(ChatColor.RED + "The nether is currently disabled");
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isOre(event.getBlock().getType())) {
            if (event.getBlock().getType() == Material.IRON_ORE || event.getBlock().getType() == Material.COAL_ORE) {
                return;
            }
            event.getBlock().setType(Material.AIR);
            ((ExperienceOrb)event.getBlock().getWorld().spawn(event.getBlock().getLocation(), ExperienceOrb.class)).setExperience(2);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(Material.IRON_INGOT));
        }
    }

    private boolean isOre(Material material) {
        return material == Material.COAL_ORE || material == Material.IRON_ORE || material == Material.LAPIS_ORE || material == Material.REDSTONE_ORE || material == Material.DIAMOND_ORE || material == Material.EMERALD_ORE || material == Material.GOLD_ORE;
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        if (event.getRecipe().getResult().getType() == Material.ENCHANTMENT_TABLE || event.getRecipe().getResult().getType() == Material.GOLDEN_APPLE || event.getRecipe().getResult().getType() == Material.ANVIL) {
            event.getWhoClicked().closeInventory();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (Main.getPlugin().allowItemDrops) {
            Location location = event.getEntity().getLocation();
            event.getEntity().getWorld().dropItemNaturally(location, new ItemStack(Material.DIAMOND, 1));
            event.getEntity().getWorld().dropItemNaturally(location, new ItemStack(Material.GOLDEN_APPLE, 1));
            event.getEntity().getWorld().dropItemNaturally(location, new ItemStack(Material.ARROW, 32));
            event.getEntity().getWorld().dropItemNaturally(location, new ItemStack(Material.STRING, 2));
        } else {
            Main.getPlugin().timebombDrops.add(new ItemStack(Material.DIAMOND, 1));
            Main.getPlugin().timebombDrops.add(new ItemStack(Material.GOLDEN_APPLE, 1));
            Main.getPlugin().timebombDrops.add(new ItemStack(Material.ARROW, 32));
            Main.getPlugin().timebombDrops.add(new ItemStack(Material.STRING, 2));
        }
    }
}

