/*
 * Decompiled with CFR 0.152.
 */
package me.purox.scenarios.listener;

import java.util.ArrayList;
import me.purox.scenarios.scenarios.Scenario;
import me.purox.scenarios.scenarios.ScenarioManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryClickListener
implements Listener {
    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        ItemStack item = event.getCurrentItem();
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (inventory != null && item != null && item.getType() != Material.AIR) {
            if (inventory.getTitle().equalsIgnoreCase(ChatColor.AQUA.toString() + ChatColor.BOLD + "Currently enabled scenarios")) {
                event.setCancelled(true);
            } else if (inventory.getTitle().equalsIgnoreCase(ChatColor.GOLD.toString() + ChatColor.BOLD + "Scenario Editor")) {
                String scenarioName = item.getItemMeta().getDisplayName().replace(ChatColor.AQUA.toString(), "");
                Scenario scenario = ScenarioManager.getInstance().getScenario(scenarioName);
                if (scenario == null) {
                    System.out.println("Error: scenario_" + scenarioName + "_does_not_exist : Please contact the author");
                    return;
                }
                scenario.setPlayer((Player)event.getWhoClicked());
                ArrayList<String> newLore = new ArrayList<String>();
                if (scenario.isEnabled()) {
                    newLore.add(ChatColor.WHITE + "    Enabled");
                    newLore.add(ChatColor.DARK_GRAY + ChatColor.STRIKETHROUGH.toString() + ">>" + ChatColor.RESET.toString() + ChatColor.WHITE + " Disabled");
                    scenario.setEnabled(false);
                } else {
                    newLore.add(ChatColor.DARK_GRAY + ChatColor.STRIKETHROUGH.toString() + ">>" + ChatColor.RESET.toString() + ChatColor.WHITE + " Enabled");
                    newLore.add(ChatColor.WHITE + "    Disabled");
                    scenario.setEnabled(true);
                }
                ItemMeta itemMeta = item.getItemMeta();
                itemMeta.setLore(newLore);
                item.setItemMeta(itemMeta);
                event.setCancelled(true);
            } else {
                return;
            }
        }
    }
}

