/*
 * Decompiled with CFR 0.152.
 */
package com.coloredcarrot.glasssmash.plugin;

import com.coloredcarrot.glasssmash.GlassSmash;
import com.coloredcarrot.glasssmash.configuration.Config;
import com.coloredcarrot.glasssmash.utilities.ValueTable4;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Wrapper {
    private static Set<ValueTable4<Integer, Location, Material, Byte>> data = new HashSet<ValueTable4<Integer, Location, Material, Byte>>();
    private static BukkitTask task;

    public static void add(Block block) {
        data.add(new ValueTable4<Integer, Location, Material, Byte>(Config.respawnTimeTicks(), block.getLocation(), block.getType(), block.getData()));
    }

    public static void init() {
        if (task != null) {
            task.cancel();
        }
        task = new BukkitRunnable(){

            public void run() {
                HashSet copy = new HashSet(data);
                for (ValueTable4 e : copy) {
                    if ((Integer)e.getV1() <= 0) {
                        ((Location)e.getV2()).getBlock().setType((Material)e.getV3());
                        ((Location)e.getV2()).getBlock().setData(((Byte)e.getV4()).byteValue());
                        data.remove(e);
                        continue;
                    }
                    e.setV1((Integer)e.getV1() - Config.updateDelayTicks());
                }
            }
        }.runTaskTimer((Plugin)GlassSmash.getPlugin(), (long)Config.respawnTimeTicks(), (long)Config.updateDelayTicks());
    }

    public static void cleanup() {
        task.cancel();
        task = null;
        GlassSmash.getPlugin().getLogger().fine("Replacing blocks...");
        for (ValueTable4<Integer, Location, Material, Byte> e : data) {
            e.getV2().getBlock().setType(e.getV3());
            e.getV2().getBlock().setData(e.getV4().byteValue());
        }
        GlassSmash.getPlugin().getLogger().fine("Replaced " + data.size() + " blocks");
        data.clear();
    }
}

