/*
 * Decompiled with CFR 0.152.
 */
package com.coloredcarrot.glasssmash.configuration;

import com.coloredcarrot.glasssmash.GlassSmash;
import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class LangConfig {
    public static final String PATH_RELOAD_INIT = "language.reload.init";
    public static final String PATH_RELOAD_FINISH = "language.reload.finish";
    public static final String DEFAULT_RELOAD_INIT = "&aReloading config files...";
    public static final String DEFAULT_RELOAD_FINISH = "&aSuccess!";
    private static String reloadInit = "&aReloading config files...";
    private static String reloadFinish = "&aSuccess!";

    public static void load() {
        YamlConfiguration yaml;
        GlassSmash.getPlugin().getDataFolder().mkdirs();
        File file = new File(GlassSmash.getPlugin().getDataFolder(), "lang.yml");
        if (!file.exists()) {
            GlassSmash.getPlugin().saveResource("lang.yml", true);
        }
        if ((yaml = YamlConfiguration.loadConfiguration((File)file)).isString(PATH_RELOAD_INIT)) {
            reloadInit = yaml.getString(PATH_RELOAD_INIT);
        } else if (!yaml.isSet(PATH_RELOAD_INIT)) {
            reloadInit = null;
        } else {
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] lang.yml is invalid @ expected string @ language.reload.init");
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] lang.yml  -> using default value (\"&aReloading config files...\")");
            reloadInit = DEFAULT_RELOAD_INIT;
        }
        if (yaml.isString(PATH_RELOAD_FINISH)) {
            reloadFinish = yaml.getString(PATH_RELOAD_FINISH);
        } else if (!yaml.isSet(PATH_RELOAD_FINISH)) {
            reloadFinish = null;
        } else {
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] lang.yml is invalid @ expected string @ language.reload.finish");
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] lang.yml  -> using default value (\"&aSuccess!\")");
            reloadFinish = DEFAULT_RELOAD_FINISH;
        }
    }

    public static String reloadInit() {
        return reloadInit;
    }

    public static String formatReloadInit() {
        return reloadInit == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)reloadInit);
    }

    public static String reloadFinish() {
        return reloadFinish;
    }

    public static String formatReloadFinish() {
        return reloadFinish == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)reloadFinish);
    }
}

