/*
 * Decompiled with CFR 0.152.
 */
package com.coloredcarrot.glasssmash.configuration;

import com.coloredcarrot.glasssmash.GlassSmash;
import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static final String PATH_RESPAWN_TIME = "config.respawn-time";
    public static final String PATH_UPDATE_DELAY = "config.update-delay";
    public static final String PATH_ACCEPT_STAINED = "config.accept-stained";
    public static final int DEFAULT_RESPAWN_TIME = 200;
    public static final int DEFAULT_UPDATE_DELAY = 200;
    public static final boolean DEFAULT_ACCEPT_STAINED = true;
    private static int respawnTimeTicks = 200;
    private static int updateDelayTicks = 5;
    private static boolean acceptStained = true;

    public static void load() {
        YamlConfiguration yaml;
        GlassSmash.getPlugin().getDataFolder().mkdirs();
        File file = new File(GlassSmash.getPlugin().getDataFolder(), "config.yml");
        if (!file.exists()) {
            GlassSmash.getPlugin().saveResource("config.yml", true);
        }
        if ((yaml = YamlConfiguration.loadConfiguration((File)file)).isInt(PATH_RESPAWN_TIME)) {
            respawnTimeTicks = yaml.getInt(PATH_RESPAWN_TIME);
        } else {
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml is invalid @ expected integer @ config.respawn-time");
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml  -> using default value (200)");
            respawnTimeTicks = 200;
        }
        if (yaml.isInt(PATH_UPDATE_DELAY)) {
            updateDelayTicks = yaml.getInt(PATH_UPDATE_DELAY);
        } else {
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml is invalid @ expected integer @ config.update-delay");
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml  -> using default value (200)");
            updateDelayTicks = 200;
        }
        if (yaml.isBoolean(PATH_ACCEPT_STAINED)) {
            acceptStained = yaml.getBoolean(PATH_ACCEPT_STAINED);
        } else {
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml is invalid @ expected boolean @ config.accept-stained");
            GlassSmash.getPlugin().getLogger().warning("[ConfigLoader] config.yml  -> using default value (true)");
            acceptStained = true;
        }
    }

    public static int respawnTimeTicks() {
        return respawnTimeTicks;
    }

    public static int updateDelayTicks() {
        return updateDelayTicks;
    }

    public static boolean acceptStained() {
        return acceptStained;
    }
}

