/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class YMLResourceBundle
extends ResourceBundle {
    private static final char TRANSLATION_CHAR = '&';
    private YamlConfiguration config;

    public YMLResourceBundle(YamlConfiguration config) {
        this.config = config;
    }

    @Override
    protected Object handleGetObject(String key) {
        String[] value = this.config.get(key);
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = ChatColor.translateAlternateColorCodes((char)'&', (String)list.get(i).toString());
            }
            value = array;
        } else if (value instanceof String) {
            String str = (String)value;
            str = str.replace("\\n", "\n");
            value = ChatColor.translateAlternateColorCodes((char)'&', (String)str);
        }
        return value;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new YamlKeyEnumeration();
    }

    private class YamlKeyEnumeration
    implements Enumeration<String> {
        private Iterator<String> keyIterator;

        public YamlKeyEnumeration() {
            Set allKeys = YMLResourceBundle.this.config.getKeys(true);
            Iterator iterator = allKeys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!YMLResourceBundle.this.config.isConfigurationSection(key)) continue;
                iterator.remove();
            }
            this.keyIterator = allKeys.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.keyIterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.keyIterator.next();
        }
    }
}

