/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import com.google.common.collect.Lists;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.YMLResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class YMLControl
extends ResourceBundle.Control {
    private static final String YML_FORMAT = "yml";
    private File localeDir;
    private String classpathDir;
    private I18N.LoadingMode mode;

    public YMLControl(File localeDir, String classpathDir, I18N.LoadingMode mode) {
        this.localeDir = localeDir;
        this.classpathDir = classpathDir;
        this.mode = mode;
    }

    @Override
    public List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return Arrays.asList(YML_FORMAT);
    }

    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        ArrayList candidates = Lists.newArrayList();
        candidates.add(locale);
        if (!locale.equals(Locale.US)) {
            candidates.add(Locale.US);
        }
        return candidates;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        Validate.notNull((Object)baseName);
        Validate.notNull((Object)locale);
        Validate.notNull((Object)format);
        Validate.notNull((Object)loader);
        ResourceBundle bundle = null;
        if (YML_FORMAT.equals(format)) {
            InputStream stream;
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, format);
            URL url = null;
            if (this.mode == I18N.LoadingMode.CLASSPATH) {
                url = this.getClass().getResource(this.classpathDir + resourceName);
            } else if (this.mode == I18N.LoadingMode.FILE_SYSTEM) {
                File resourceFile = new File(this.localeDir, resourceName);
                url = resourceFile.exists() && resourceFile.isFile() ? resourceFile.toURI().toURL() : this.getClass().getResource(this.classpathDir + resourceName);
            }
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            if (reload) {
                connection.setUseCaches(false);
            }
            if ((stream = connection.getInputStream()) != null) {
                StringBuilder builder;
                InputStreamReader reader = new InputStreamReader(stream, I18N.UTF8_CHARSET);
                YamlConfiguration config = new YamlConfiguration();
                try (BufferedReader bufferedReader = new BufferedReader(reader);){
                    String read;
                    builder = new StringBuilder();
                    while ((read = bufferedReader.readLine()) != null) {
                        builder.append(read);
                        builder.append('\n');
                    }
                }
                try {
                    config.loadFromString(builder.toString());
                }
                catch (InvalidConfigurationException e) {
                    throw new InstantiationException(e.getMessage());
                }
                bundle = new YMLResourceBundle(config);
            }
        } else {
            bundle = super.newBundle(baseName, locale, format, loader, reload);
        }
        return bundle;
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        long lastModified;
        String bundleName;
        String resourceName;
        File resourceFile;
        boolean reload = format.equals(YML_FORMAT) ? ((resourceFile = new File(this.localeDir, resourceName = this.toResourceName(bundleName = this.toBundleName(baseName, locale), format))).exists() && resourceFile.isFile() ? (lastModified = resourceFile.lastModified()) > loadTime : super.needsReload(baseName, locale, format, loader, bundle, loadTime)) : super.needsReload(baseName, locale, format, loader, bundle, loadTime);
        return reload;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return -1L;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }
}

