/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ParsedMessage {
    private static final char VARIABLE_OPERATOR = '$';
    private static final char[] BRACKETS = new char[]{'[', ']'};
    private String message;
    private List<MessageVariable> variables;

    protected ParsedMessage(String message, List<MessageVariable> variables) {
        this.message = message;
        this.variables = variables;
    }

    public static ParsedMessage parseMessage(String message) throws ParseException {
        int length = message.length();
        ArrayList variables = Lists.newArrayList();
        ParseState state = ParseState.SEARCH_VARIABLE_OPERATOR;
        int noIndex = -1;
        int variableStartIndex = -1;
        String variableName = "";
        block5: for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            switch (state) {
                case SEARCH_VARIABLE_OPERATOR: {
                    if (c != '$') continue block5;
                    state = ParseState.EXPECT_BRACKETS;
                    variableStartIndex = i;
                    continue block5;
                }
                case EXPECT_BRACKETS: {
                    if (c != BRACKETS[0]) continue block5;
                    state = ParseState.READ_VARIABLE;
                    continue block5;
                }
                case READ_VARIABLE: {
                    if (c != BRACKETS[1]) {
                        variableName = variableName + c;
                        continue block5;
                    }
                    MessageVariable variable = new MessageVariable(variableStartIndex, i, variableName);
                    variables.add(variable);
                    variableName = "";
                    variableStartIndex = -1;
                    state = ParseState.SEARCH_VARIABLE_OPERATOR;
                    continue block5;
                }
                default: {
                    throw new ParseException("state was null when parsing", i);
                }
            }
        }
        ParsedMessage parsedMessage = new ParsedMessage(message, variables);
        return parsedMessage;
    }

    public ParsedMessage setVariable(String name, String value) {
        for (MessageVariable var : this.variables) {
            if (!var.getName().equals(name)) continue;
            var.setValue(value);
        }
        return this;
    }

    public String toString() {
        String message = this.message;
        int offset = 0;
        for (MessageVariable var : this.variables) {
            if (var.getValue() == null) continue;
            String firstPart = message.substring(0, var.getStartIndex() + offset);
            String secondPart = message.substring(var.getEndIndex() + 1 + offset);
            String value = var.getValue();
            message = firstPart + value + secondPart;
            offset += var.getStartIndex() - var.getEndIndex() + value.length() - 1;
        }
        return message;
    }

    static class MessageVariable {
        private int startIndex;
        private int endIndex;
        private String name;
        private String value;

        public MessageVariable(int startIndex, int endIndex, String name) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.name = name;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static enum ParseState {
        SEARCH_VARIABLE_OPERATOR,
        EXPECT_BRACKETS,
        READ_VARIABLE;

    }
}

