/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import com.google.common.collect.Maps;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.I18NBuilder;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class I18NManager {
    private static final Object initLock = new Object();
    private static I18NBuilder globalBuilder;
    private static I18N global;
    private Map<String, I18N> registered = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18N getGlobal() {
        Object object = initLock;
        synchronized (object) {
            if (global == null) {
                if (globalBuilder == null) {
                    throw new IllegalStateException("No global builder has been set for initializing");
                }
                global = globalBuilder.build();
            }
        }
        return global;
    }

    public static void setGlobalBuilder(I18NBuilder builder) {
        if (globalBuilder != null) {
            throw new IllegalStateException("Global I18NBuilder has already been set");
        }
        globalBuilder = builder;
    }

    public void registerI18N(String name, I18N i18n) {
        Validate.isTrue((!this.registered.containsKey(name) ? 1 : 0) != 0, (String)"I18N instance already registered");
        i18n.setParent(global);
        this.registered.put(name, i18n);
    }

    public I18N registerI18N(String name, I18NBuilder builder) {
        I18N i18n = builder.build();
        this.registerI18N(name, i18n);
        return i18n;
    }

    public void unregisterI18N(String name) {
        Validate.isTrue((boolean)this.registered.containsKey(name), (String)"I18N instance is not registered");
        this.registered.remove(name);
    }

    public I18N getI18N(String name) {
        return this.registered.get(name);
    }

    public void reloadAll(Locale locale) {
        if (global != null) {
            global.setLocale(locale);
            global.load();
        }
        for (I18N i18n : this.registered.values()) {
            i18n.setLocale(locale);
            i18n.load();
        }
    }
}

