/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import de.xaniox.simpletrading.i18n.I18N;
import java.io.File;
import java.util.Locale;
import java.util.logging.Logger;

public final class I18NBuilder {
    private Locale locale;
    private ClassLoader classLoader;
    private Logger logger;
    private I18N.LoadingMode loadingMode;
    private File fileSystemFolder;
    private String classpathFolder;

    public static I18NBuilder builder() {
        return new I18NBuilder();
    }

    private I18NBuilder() {
    }

    public I18N build() {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        I18N i18n = new I18N(this.locale, this.loadingMode, this.fileSystemFolder, this.classpathFolder, loader, this.logger);
        return i18n;
    }

    public I18NBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public I18NBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public I18NBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public I18NBuilder setLoadingMode(I18N.LoadingMode loadingMode) {
        this.loadingMode = loadingMode;
        return this;
    }

    public I18NBuilder setFileSystemFolder(File fileSystemFolder) {
        this.fileSystemFolder = fileSystemFolder;
        return this;
    }

    public I18NBuilder setClasspathFolder(String classpathFolder) {
        this.classpathFolder = classpathFolder;
        return this;
    }
}

