/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.i18n;

import com.google.common.collect.Lists;
import de.xaniox.simpletrading.SimpleTrading;
import de.xaniox.simpletrading.i18n.ParsedMessage;
import de.xaniox.simpletrading.i18n.YMLControl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConfigurationOptions;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class I18N {
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final List<String> DEFAULT_CLASSPATH_LOCALE_RESOURCES = Lists.newArrayList((Object[])new String[]{"locale_en_US.yml", "locale_de_DE.yml"});
    private static final String FALLBACK_FILE = "locale_en_US.yml";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_EXTENSION = ".jar";
    private static final String JAR_ENTRY_SEPERATOR = "/";
    private static final String LOCALE_FILE_REGEX = "locale_[a-z]{2}(_[A-Z]{2})?\\.yml";
    private static final YamlRepresenter YAML_REPRESENTER = new YamlRepresenter();
    private static final DumperOptions DUMPER_OPTIONS = new DumperOptions();
    static final Locale FALLBACK_LOCALE = Locale.US;
    private Locale locale;
    private ClassLoader classLoader;
    private Logger logger;
    private LoadingMode mode;
    private YMLControl defaultControl;
    private File fileSystemFolder;
    private String classpathFolder;
    private I18N parent;
    private ResourceBundle bundle;

    public I18N() {
    }

    protected I18N(Locale locale, LoadingMode mode, File fileSystemFolder, String classpathFolder, ClassLoader loader, Logger logger) {
        this.defaultControl = new YMLControl(fileSystemFolder, classpathFolder, mode);
        this.locale = locale;
        this.mode = mode;
        this.fileSystemFolder = fileSystemFolder;
        if (!classpathFolder.endsWith(String.valueOf(JAR_ENTRY_SEPERATOR)) && !classpathFolder.isEmpty()) {
            classpathFolder = classpathFolder + JAR_ENTRY_SEPERATOR;
        }
        this.classpathFolder = classpathFolder;
        this.classLoader = loader;
        this.logger = logger;
        this.load();
    }

    public void load() {
        if (this.mode == LoadingMode.FILE_SYSTEM) {
            try {
                this.copyClasspathResources();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not copy locale resource file, using classpath resource", e);
            }
        }
        this.loadBundle();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.loadBundle();
    }

    private void loadBundle() {
        this.bundle = ResourceBundle.getBundle("locale", this.locale, this.defaultControl);
    }

    public void setParent(I18N parent) {
        this.parent = parent;
    }

    public void copyClasspathResources() throws IOException {
        Iterator entryName;
        Object entries;
        if (this.mode != LoadingMode.FILE_SYSTEM) {
            throw new IllegalStateException("Resource files can only be copied on LoadingMode.FILE_SYSTEM mode");
        }
        ArrayList classpathResources = Lists.newArrayList();
        if (this.classLoader instanceof URLClassLoader) {
            URL[] urls;
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader;
            for (URL url : urls = urlClassLoader.getURLs()) {
                File file;
                if (!url.getProtocol().equals(FILE_PROTOCOL)) continue;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (!file.getName().endsWith(JAR_EXTENSION)) continue;
                try (JarFile jar = new JarFile(file);){
                    entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String fileName;
                        JarEntry entry = entries.nextElement();
                        entryName = entry.getName();
                        String[] nameComponents = ((String)((Object)entryName)).split(JAR_ENTRY_SEPERATOR);
                        StringBuilder folderBuilder = new StringBuilder();
                        for (int i = 0; i < nameComponents.length - 1; ++i) {
                            folderBuilder.append(nameComponents[i]).append(JAR_ENTRY_SEPERATOR);
                        }
                        String folder = folderBuilder.toString();
                        if (!folder.equals(this.classpathFolder) || !(fileName = nameComponents[nameComponents.length - 1]).matches(LOCALE_FILE_REGEX)) continue;
                        classpathResources.add(fileName);
                    }
                }
            }
        } else {
            classpathResources.addAll(DEFAULT_CLASSPATH_LOCALE_RESOURCES);
        }
        for (String localeRes : classpathResources) {
            File localeFile = new File(this.fileSystemFolder, localeRes);
            if (localeFile.exists()) continue;
            URL localeResourceUrl = this.classLoader.getResource(this.classpathFolder + localeRes);
            SimpleTrading.copyResource(localeResourceUrl, localeFile);
        }
        for (File localeFile : this.fileSystemFolder.listFiles()) {
            StringBuilder resourceBuilder;
            StringBuilder fileBuilder;
            if (!localeFile.getName().matches(LOCALE_FILE_REGEX)) continue;
            URL classpathResource = this.classLoader.getResource(this.classpathFolder + localeFile.getName());
            if (classpathResource == null) {
                classpathResource = this.classLoader.getResource(this.classpathFolder + FALLBACK_FILE);
            }
            URLConnection connection = classpathResource.openConnection();
            connection.setUseCaches(false);
            BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(localeFile), UTF8_CHARSET));
            entries = null;
            try {
                BufferedReader resourceReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), UTF8_CHARSET));
                entryName = null;
                try {
                    String read;
                    fileBuilder = new StringBuilder();
                    resourceBuilder = new StringBuilder();
                    while ((read = fileReader.readLine()) != null) {
                        fileBuilder.append(read).append('\n');
                    }
                    while ((read = resourceReader.readLine()) != null) {
                        resourceBuilder.append(read).append('\n');
                    }
                }
                catch (Throwable read) {
                    entryName = read;
                    throw read;
                }
                finally {
                    if (resourceReader != null) {
                        if (entryName != null) {
                            try {
                                resourceReader.close();
                            }
                            catch (Throwable read) {
                                ((Throwable)((Object)entryName)).addSuppressed(read);
                            }
                        } else {
                            resourceReader.close();
                        }
                    }
                }
            }
            catch (Throwable resourceReader) {
                entries = resourceReader;
                throw resourceReader;
            }
            finally {
                if (fileReader != null) {
                    if (entries != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable resourceReader) {
                            ((Throwable)entries).addSuppressed(resourceReader);
                        }
                    } else {
                        fileReader.close();
                    }
                }
            }
            YamlConfiguration fileConfig = new YamlConfiguration();
            YamlConfiguration resourceConfig = new YamlConfiguration();
            try {
                fileConfig.loadFromString(fileBuilder.toString());
                resourceConfig.loadFromString(resourceBuilder.toString());
            }
            catch (InvalidConfigurationException e) {
                this.logger.log(Level.SEVERE, "Could not validate " + localeFile.getName() + ", ignoring file", e);
                continue;
            }
            boolean changesToCommit = false;
            for (String key : resourceConfig.getKeys(true)) {
                if (resourceConfig.isConfigurationSection(key) || fileConfig.contains(key)) continue;
                fileConfig.set(key, resourceConfig.get(key));
                changesToCommit = true;
            }
            if (!changesToCommit) continue;
            YamlConfigurationOptions options = fileConfig.options();
            DUMPER_OPTIONS.setIndent(options.indent());
            Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), (Representer)YAML_REPRESENTER, DUMPER_OPTIONS);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(localeFile), UTF8_CHARSET);){
                yaml.dump((Object)fileConfig.getValues(false), (Writer)writer);
                writer.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        String msg;
        ResourceBundle resourceBundle = this.bundle;
        synchronized (resourceBundle) {
            try {
                msg = this.bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (this.parent != null) {
                    msg = this.parent.getString(key);
                }
                throw e;
            }
        }
        return msg;
    }

    public ParsedMessage getVarString(String key) {
        String message = this.getString(key);
        try {
            return ParsedMessage.parseMessage(message);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Illegal message \"" + message + "\"", e);
            ArrayList emptySet = Lists.newArrayList();
            return new ParsedMessage(message, emptySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringArray(String key) {
        String[] array;
        ResourceBundle resourceBundle = this.bundle;
        synchronized (resourceBundle) {
            try {
                array = this.bundle.getStringArray(key);
            }
            catch (MissingResourceException e) {
                if (this.parent != null) {
                    array = this.parent.getStringArray(key);
                }
                throw e;
            }
        }
        return array;
    }

    static {
        DUMPER_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        DUMPER_OPTIONS.setAllowUnicode(true);
        YAML_REPRESENTER.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
    }

    public static enum LoadingMode {
        CLASSPATH,
        FILE_SYSTEM;

    }
}

