/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.config;

import de.xaniox.simpletrading.config.ControlManager;
import de.xaniox.simpletrading.config.ControlMode;
import de.xaniox.simpletrading.config.TradeConfiguration;
import java.util.List;
import org.bukkit.World;

public class WorldControlManager
extends ControlManager<World> {
    private List<String> worldList;

    public WorldControlManager(ControlMode mode, List<String> worldList) {
        super(mode);
        this.worldList = worldList;
    }

    public WorldControlManager(TradeConfiguration config) {
        super(config.getWorldControlMode());
        this.worldList = config.getWorldControlList();
    }

    @Override
    public void updateValues(TradeConfiguration config) {
        super.setMode(config.getWorldControlMode());
        this.worldList = config.getWorldControlList();
    }

    @Override
    protected boolean isAllowedBlacklist(World item) {
        for (String worldName : this.worldList) {
            if (!worldName.equals(item.getName())) continue;
            return false;
        }
        return true;
    }
}

