/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.config;

import com.google.common.collect.Lists;
import de.xaniox.simpletrading.config.ControlMode;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class TradeConfiguration {
    private static final String BLOCKDATA_SEPERATOR = ":";
    private static final String PLAYERNAME_PLACEHOLDER = "@p";
    public static final int NO_MAX_DISTANCE = -1;
    public static final int CURRENT_CONFIG_VERSION = 7;
    public static final String DESTINATION_FILE_NAME = "config.yml";
    public static final String CLASSPATH_RESOURCE_NAME = "/config.yml";
    private ItemStackData acceptBlockData;
    private ItemStackData declineBlockData;
    private ItemStackData seperatorBlockData;
    private ItemStackData moneyStatusBlockData;
    private ItemStackData moneyAddRemoveBlockData;
    private ItemStackData xpStatusBlockData;
    private ItemStackData xpAddRemoveBlockData;
    private Locale locale;
    private String inventoryName;
    private int moneyValue1;
    private int moneyValue2;
    private int moneyValue3;
    private int expValue1;
    private int expValue2;
    private int expValue3;
    private int maximumTradeDistance;
    private boolean allowCreativeTrading;
    private int timeout;
    private boolean useXpTrading;
    private boolean useMoneyTrading;
    private boolean useShiftTrading;
    private int maxMoneyTrading;
    private boolean abortOnDecline;
    private ControlMode itemControlMode;
    private List<ItemStackData> itemControlItems;
    private List<String> itemControlLores;
    private ControlMode worldControlMode;
    private List<String> worldControlList;

    public TradeConfiguration(Configuration config) {
        this.loadByConfiguration(config);
    }

    public void loadByConfiguration(Configuration config) {
        ConfigurationSection blockSection = config.getConfigurationSection("blocks");
        this.acceptBlockData = ItemStackData.fromConfigString(blockSection.getString("accept", "ink_sack:10"), BLOCKDATA_SEPERATOR);
        this.declineBlockData = ItemStackData.fromConfigString(blockSection.getString("decline", "ink_sack:1"), BLOCKDATA_SEPERATOR);
        this.seperatorBlockData = ItemStackData.fromConfigString(blockSection.getString("seperator", "barrier"), BLOCKDATA_SEPERATOR);
        this.moneyStatusBlockData = ItemStackData.fromConfigString(blockSection.getString("money-status", "gold_nugget"), BLOCKDATA_SEPERATOR);
        this.moneyAddRemoveBlockData = ItemStackData.fromConfigString(blockSection.getString("money-add-remove", "gold_nugget"), BLOCKDATA_SEPERATOR);
        this.xpStatusBlockData = ItemStackData.fromConfigString(blockSection.getString("xp-status", "exp_bottle"), BLOCKDATA_SEPERATOR);
        this.xpAddRemoveBlockData = ItemStackData.fromConfigString(blockSection.getString("xp-add-remove", "exp_bottle"), BLOCKDATA_SEPERATOR);
        ConfigurationSection localizationSection = config.getConfigurationSection("localization");
        String localeString = localizationSection.getString("locale");
        this.locale = TradeConfiguration.parseLocale(localeString);
        ConfigurationSection inventorySection = config.getConfigurationSection("inventory");
        this.inventoryName = inventorySection.getString("name", "SimpleTrading - @p");
        this.moneyValue1 = inventorySection.getInt("money-value-1", 50);
        this.moneyValue2 = inventorySection.getInt("money-value-2", 100);
        this.moneyValue3 = inventorySection.getInt("money-value-3", 500);
        this.expValue1 = inventorySection.getInt("exp-value-1", 5);
        this.expValue2 = inventorySection.getInt("exp-value-2", 50);
        this.expValue3 = inventorySection.getInt("exp-value-3", 100);
        ConfigurationSection globalSection = config.getConfigurationSection("global");
        this.maximumTradeDistance = globalSection.getInt("max-distance", 15);
        this.allowCreativeTrading = globalSection.getBoolean("creative-trading", true);
        this.timeout = globalSection.getInt("timeout", 60);
        this.useXpTrading = globalSection.getBoolean("use-xp-trading", true);
        this.useMoneyTrading = globalSection.getBoolean("use-money-trading", true);
        this.useShiftTrading = globalSection.getBoolean("use-shift-trading", true);
        this.maxMoneyTrading = globalSection.getInt("max-money-trading", -1);
        this.abortOnDecline = globalSection.getBoolean("abort-on-decline", false);
        ConfigurationSection itemControlSection = config.getConfigurationSection("item-control");
        this.itemControlMode = ControlMode.getMode(itemControlSection.getString("control-mode"), ControlMode.BLACKLIST);
        List controlItemStringList = itemControlSection.getStringList("item-list");
        this.itemControlItems = Lists.newArrayList();
        for (String controlItemString : controlItemStringList) {
            this.itemControlItems.add(ItemStackData.fromConfigString(controlItemString, BLOCKDATA_SEPERATOR));
        }
        this.itemControlLores = itemControlSection.getStringList("item-lore");
        ConfigurationSection worldControlSection = config.getConfigurationSection("world-control");
        this.worldControlMode = ControlMode.getMode(worldControlSection.getString("control-mode"), ControlMode.BLACKLIST);
        this.worldControlList = worldControlSection.getStringList("world-list");
    }

    private static Locale parseLocale(String localeString) {
        String variant;
        String[] parts = localeString.split("_");
        String language = parts[0];
        String country = parts.length > 1 ? parts[1] : null;
        String string = variant = parts.length > 2 ? parts[2] : null;
        Locale locale = country == null && variant == null ? new Locale(language) : (country != null && variant == null ? new Locale(language, country) : new Locale(language, country, variant));
        return locale;
    }

    public ItemStackData getAcceptBlockData() {
        return this.acceptBlockData;
    }

    public ItemStackData getDeclineBlockData() {
        return this.declineBlockData;
    }

    public ItemStackData getSeperatorBlockData() {
        return this.seperatorBlockData;
    }

    public ItemStackData getMoneyStatusBlockData() {
        return this.moneyStatusBlockData;
    }

    public ItemStackData getMoneyAddRemoveBlockData() {
        return this.moneyAddRemoveBlockData;
    }

    public ItemStackData getXpStatusBlockData() {
        return this.xpStatusBlockData;
    }

    public ItemStackData getXpAddRemoveBlockData() {
        return this.xpAddRemoveBlockData;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getInventoryName(String nameReplacement) {
        return this.inventoryName.replace(PLAYERNAME_PLACEHOLDER, nameReplacement);
    }

    public int getMoneyValue1() {
        return this.moneyValue1;
    }

    public int getMoneyValue2() {
        return this.moneyValue2;
    }

    public int getMoneyValue3() {
        return this.moneyValue3;
    }

    public int getExpValue1() {
        return this.expValue1;
    }

    public int getExpValue2() {
        return this.expValue2;
    }

    public int getExpValue3() {
        return this.expValue3;
    }

    public int getMaximumTradeDistance() {
        return this.maximumTradeDistance;
    }

    public boolean allowsCreativeTrading() {
        return this.allowCreativeTrading;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean usesXpTrading() {
        return this.useXpTrading;
    }

    public boolean usesMoneyTrading() {
        return this.useMoneyTrading;
    }

    public boolean usesShiftTrading() {
        return this.useShiftTrading;
    }

    public int getMaxMoneyTrading() {
        return this.maxMoneyTrading;
    }

    public boolean isAbortOnDecline() {
        return this.abortOnDecline;
    }

    public ControlMode getItemControlMode() {
        return this.itemControlMode;
    }

    public List<ItemStackData> getItemControlList() {
        return this.itemControlItems;
    }

    public List<String> getItemControlLoreList() {
        return this.itemControlLores;
    }

    public ControlMode getWorldControlMode() {
        return this.worldControlMode;
    }

    public List<String> getWorldControlList() {
        return this.worldControlList;
    }

    public static class ItemStackData {
        private Material material;
        private byte data;

        public ItemStackData(Material material, byte data) {
            this.material = material;
            this.data = data;
        }

        public static ItemStackData fromConfigString(String configStr, String seperator) {
            String[] components = configStr.split(seperator);
            String materialString = components[0];
            Material material = null;
            byte data = 0;
            for (Material mat : Material.values()) {
                if (!mat.name().equalsIgnoreCase(materialString) && !mat.name().replace("_", "").equalsIgnoreCase(materialString)) continue;
                material = mat;
            }
            if (material == null) {
                try {
                    int legacyId = Integer.parseInt(materialString);
                    material = Material.getMaterial((int)legacyId);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Config-String \"" + configStr + "\" material/block-id is invalid");
                }
            }
            if (components.length > 1) {
                try {
                    int legacyData = Integer.parseInt(components[1]);
                    data = (byte)legacyData;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Config-String \"" + configStr + "\" is invalid: Illegal block data");
                }
            }
            return new ItemStackData(material, data);
        }

        public Material getMaterial() {
            return this.material;
        }

        public byte getData() {
            return this.data;
        }

        public ItemStack newItemStack() {
            return this.newItemStack(1);
        }

        public ItemStack newItemStack(int amount) {
            ItemStack stack = new ItemStack(this.material.getId(), amount, (short)this.data);
            return stack;
        }
    }
}

