/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading.config;

import de.xaniox.simpletrading.config.ControlManager;
import de.xaniox.simpletrading.config.ControlMode;
import de.xaniox.simpletrading.config.TradeConfiguration;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemControlManager
extends ControlManager<ItemStack> {
    private List<TradeConfiguration.ItemStackData> items;
    private List<String> lores;

    public ItemControlManager(ControlMode mode, List<TradeConfiguration.ItemStackData> items, List<String> lores) {
        super(mode);
        this.items = items;
        this.lores = lores;
    }

    public ItemControlManager(TradeConfiguration config) {
        super(config.getItemControlMode());
        this.updateValues(config);
    }

    @Override
    public void updateValues(TradeConfiguration config) {
        this.items = config.getItemControlList();
        this.lores = config.getItemControlLoreList();
    }

    @Override
    protected boolean isAllowedBlacklist(ItemStack stack) {
        for (TradeConfiguration.ItemStackData data : this.items) {
            if (data.getMaterial() != stack.getType() || data.getData() != stack.getData().getData()) continue;
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return true;
        }
        List lore = meta.getLore();
        if (lore != null) {
            for (String loreStr : this.lores) {
                loreStr = ChatColor.stripColor((String)loreStr);
                for (String itemLoreStr : lore) {
                    if (!loreStr.equals(itemLoreStr = ChatColor.stripColor((String)itemLoreStr))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

