/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading;

import com.google.common.collect.Sets;
import de.xaniox.simpletrading.DefaultTrade;
import de.xaniox.simpletrading.Permissions;
import de.xaniox.simpletrading.SimpleTrading;
import de.xaniox.simpletrading.Trade;
import de.xaniox.simpletrading.TradePlayer;
import de.xaniox.simpletrading.TradeState;
import de.xaniox.simpletrading.config.ItemControlManager;
import de.xaniox.simpletrading.config.TradeConfiguration;
import de.xaniox.simpletrading.config.WorldControlManager;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.I18NManager;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class TradeFactory
implements Listener {
    private final I18N i18n = I18NManager.getGlobal();
    private final SimpleTrading plugin;
    private final TradeConfiguration config;
    private final Set<Trade> trades;
    private final Economy econ;
    private final ItemControlManager controlManager;

    public TradeFactory(SimpleTrading plugin, TradeConfiguration config, Economy econ, ItemControlManager controlManager) {
        this.plugin = plugin;
        this.config = config;
        this.trades = Sets.newLinkedHashSet();
        this.econ = econ;
        this.controlManager = controlManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public Trade initiateTrade(Player initiator, Player partner) {
        DefaultTrade trade;
        if (this.isInvolvedInTrade(initiator)) {
            trade = null;
        } else if (this.isInvolvedInTrade(partner)) {
            initiator.sendMessage(this.i18n.getVarString("general.partner-already-involved").setVariable("player", partner.getName()).toString());
            trade = null;
        } else {
            DefaultTrade simpleTrade = new DefaultTrade(initiator, partner, this.config, this.econ, this.controlManager, this.plugin);
            int timeout = this.config.getTimeout();
            final BukkitTask timeoutTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new TimeoutRunnable(simpleTrade), (long)timeout * 20L);
            simpleTrade.setListener(new DefaultTrade.StateChangedListener(){

                @Override
                public void onStateChanged(Trade trade, TradeState newState) {
                    switch (newState) {
                        case CANCELLED: 
                        case CONTRACTED: {
                            TradeFactory.this.trades.remove(trade);
                        }
                        case TRADING: {
                            int taskId = timeoutTask.getTaskId();
                            BukkitScheduler scheduler = Bukkit.getScheduler();
                            if (!scheduler.isCurrentlyRunning(taskId) && !scheduler.isQueued(taskId)) break;
                            timeoutTask.cancel();
                        }
                    }
                }
            });
            this.trades.add(simpleTrade);
            trade = simpleTrade;
            initiator.sendMessage(this.i18n.getVarString("general.trade-requested").setVariable("player", partner.getName()).toString());
            partner.sendMessage(this.i18n.getVarString("general.trade-request-received").setVariable("player", initiator.getName()).toString());
        }
        return trade;
    }

    public void declineTrade(Player decliner) {
        Trade trade = this.getTrade(decliner);
        if (trade == null) {
            throw new IllegalStateException(decliner.getName() + " is not involved in any trade. Can not decline.");
        }
        if (trade.getState() != TradeState.REQUESTED) {
            return;
        }
        trade.setState(TradeState.CANCELLED);
        this.trades.remove(trade);
        Player initiator = trade.getInitiator().getPlayer();
        initiator.sendMessage(this.i18n.getVarString("general.trade-request-declined").setVariable("player", decliner.getName()).toString());
    }

    private void timeoutTrade(Trade trade) {
        if (trade.getState() != TradeState.REQUESTED) {
            return;
        }
        this.trades.remove(trade);
        trade.stop(Trade.StopCause.TIMEOUT, trade.getInitiator());
    }

    public void acceptTrade(Player accepter) {
        Trade trade = this.getTrade(accepter);
        if (trade == null) {
            throw new IllegalStateException(accepter.getName() + " is not involved in any trade. Can not accept.");
        }
        if (trade.getState() != TradeState.REQUESTED) {
            return;
        }
        Player initiator = trade.getInitiator().getPlayer();
        initiator.sendMessage(this.i18n.getVarString("general.trade-accepted").setVariable("player", accepter.getName()).toString());
        trade.accept();
    }

    public void stopTrade(Trade trade, Trade.StopCause cause, Player who) {
        TradePlayer tradePlayer;
        if (!this.trades.contains(trade)) {
            return;
        }
        if (trade.getInitiator().getPlayer() == who) {
            tradePlayer = trade.getInitiator();
        } else if (trade.getPartner().getPlayer() == who) {
            tradePlayer = trade.getPartner();
        } else {
            throw new IllegalArgumentException(who.getName() + " is not affiliated in this trade");
        }
        trade.stop(cause, tradePlayer);
        this.trades.remove(trade);
    }

    public void stopAllTrades(Trade.StopCause cause) {
        for (Trade trade : this.trades) {
            trade.stop(cause, trade.getInitiator());
        }
    }

    public boolean isInvolvedInTrade(Player player) {
        for (Trade trade : this.trades) {
            if (trade.getInitiator().getPlayer() != player && trade.getPartner().getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    public Trade getTrade(Player player) {
        for (Trade trade : this.trades) {
            if (trade.getInitiator().getPlayer() != player && trade.getPartner().getPlayer() != player) continue;
            return trade;
        }
        return null;
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        if (!this.config.usesShiftTrading()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        Entity interacted = event.getRightClicked();
        if (!(interacted instanceof Player)) {
            return;
        }
        Player tradePartner = (Player)interacted;
        if (!(this.config.allowsCreativeTrading() || player.getGameMode() != GameMode.CREATIVE && tradePartner.getGameMode() != GameMode.CREATIVE)) {
            player.sendMessage(this.i18n.getVarString("general.partner-in-creative").setVariable("player", tradePartner.getName()).toString());
            return;
        }
        WorldControlManager worldControlManager = this.plugin.getWorldControlManager();
        if (!worldControlManager.isAllowed(player.getWorld())) {
            player.sendMessage(this.i18n.getString("command.cannot-trade-in-world"));
            return;
        }
        Trade trade = this.getTrade(player);
        if (trade == null) {
            if (!player.hasPermission(Permissions.TRADE_INITIATE_SHIFT.getPermission())) {
                player.sendMessage(ChatColor.RED + "You don't have permission to trade!");
                return;
            }
            this.initiateTrade(player, tradePartner);
        } else if (trade.getPartner().getPlayer() == player) {
            if (!player.hasPermission(Permissions.TRADE_ACCEPT_SHIFT.getPermission())) {
                player.sendMessage(ChatColor.RED + "You don't have the permission the accept trades!");
                return;
            }
            this.acceptTrade(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        Trade trade = this.getTrade(player);
        if (trade == null || trade.getState() != TradeState.TRADING) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity entity = event.getPlayer();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Trade trade = this.getTrade(player);
        if (trade == null || trade.getState() != TradeState.TRADING) {
            return;
        }
        this.stopTrade(trade, Trade.StopCause.INVENTORY_CLOSE, player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handleQuit((PlayerEvent)event);
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.handleQuit((PlayerEvent)event);
    }

    private void handleQuit(PlayerEvent event) {
        Player player = event.getPlayer();
        Trade trade = this.getTrade(player);
        if (trade == null) {
            return;
        }
        this.stopTrade(trade, Trade.StopCause.QUIT, player);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Trade trade = this.getTrade(player);
        if (trade == null || trade.getState() != TradeState.TRADING) {
            return;
        }
        this.stopTrade(trade, Trade.StopCause.DEATH, player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Trade trade = this.getTrade(player);
        if (trade == null || trade.getState() != TradeState.TRADING) {
            return;
        }
        trade.onInventoryClick(event);
    }

    private class TimeoutRunnable
    implements Runnable {
        private Trade trade;

        public TimeoutRunnable(Trade trade) {
            this.trade = trade;
        }

        @Override
        public void run() {
            TradeFactory.this.timeoutTrade(this.trade);
        }
    }
}

