/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading;

import de.xaniox.simpletrading.CommandTrade;
import de.xaniox.simpletrading.MoveCheckerRunnable;
import de.xaniox.simpletrading.Trade;
import de.xaniox.simpletrading.TradeFactory;
import de.xaniox.simpletrading.config.ItemControlManager;
import de.xaniox.simpletrading.config.TradeConfiguration;
import de.xaniox.simpletrading.config.WorldControlManager;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.I18NBuilder;
import de.xaniox.simpletrading.i18n.I18NManager;
import de.xaniox.simpletrading.metrics.Metrics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class SimpleTrading
extends JavaPlugin {
    private static final String I18N_CLASSPATH_FOLDER = "i18n/";
    private static final String VAULT_PLUGIN_NAME = "Vault";
    private TradeConfiguration config;
    private I18NManager i18nManager;
    private TradeFactory factory;
    private BukkitTask movementTask;
    private ItemControlManager itemControlManager;
    private WorldControlManager worldControlManager;
    private boolean usingVault;
    private Economy econ;
    private boolean isDisabling;

    public void onEnable() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveDefaultConfig();
        }
        Path dataFolder = this.getDataFolder().toPath();
        YamlConfiguration checkConfig = YamlConfiguration.loadConfiguration((File)configFile);
        this.checkConfigVersions((Configuration)checkConfig, dataFolder);
        File i18nFolder = new File(this.getDataFolder(), "i18n");
        i18nFolder.mkdirs();
        this.config = new TradeConfiguration((Configuration)this.getConfig());
        I18NManager.setGlobalBuilder(I18NBuilder.builder().setFileSystemFolder(i18nFolder).setClasspathFolder(I18N_CLASSPATH_FOLDER).setLoadingMode(I18N.LoadingMode.FILE_SYSTEM).setLocale(this.config.getLocale()).setLogger(this.getLogger()));
        this.i18nManager = new I18NManager();
        this.initVaultHook();
        this.itemControlManager = new ItemControlManager(this.config);
        this.worldControlManager = new WorldControlManager(this.config);
        this.factory = new TradeFactory(this, this.config, this.econ, this.itemControlManager);
        this.getCommand("trade").setExecutor((CommandExecutor)new CommandTrade(this));
        this.movementTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new MoveCheckerRunnable(this.factory, this.config), 20L, 30L);
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            this.getLogger().warning("Could not start metrics service: " + e);
        }
        PluginDescriptionFile pdf = this.getDescription();
        String version = pdf.getVersion();
        this.getLogger().info("SimpleTrading v" + version + " enabled!");
    }

    public void onDisable() {
        this.isDisabling = true;
        HandlerList.unregisterAll((Plugin)this);
        if (this.movementTask != null) {
            this.movementTask.cancel();
        }
        if (this.factory != null) {
            this.factory.stopAllTrades(Trade.StopCause.SERVER_SHUTDOWN);
        }
    }

    private void checkConfigVersions(Configuration config, Path dataFolder) {
        if (config.getInt("config-version", 0) < 7) {
            Path configSource = dataFolder.resolve("config.yml");
            Path configTarget = dataFolder.resolve("config_old.yml");
            try {
                Files.move(configSource, configTarget, StandardCopyOption.REPLACE_EXISTING);
                URL configResource = ((Object)((Object)this)).getClass().getResource("/config.yml");
                SimpleTrading.copyResource(configResource, configSource.toFile());
                ConsoleCommandSender sender = Bukkit.getConsoleSender();
                sender.sendMessage(ChatColor.RED + "Due to a SimpleTrading update your old configuration has been renamed");
                sender.sendMessage(ChatColor.RED + "to config_old.yml and a new one has been generated. Make sure to");
                sender.sendMessage(ChatColor.RED + "apply your old changes to the new config!");
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create updated configuration due to an IOException", e);
            }
        }
    }

    public void initVaultHook() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!pluginManager.isPluginEnabled(VAULT_PLUGIN_NAME)) {
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.usingVault = true;
        this.econ = (Economy)rsp.getProvider();
    }

    public void reload() {
        this.reloadConfig();
        this.config.loadByConfiguration((Configuration)this.getConfig());
        this.i18nManager.reloadAll(this.config.getLocale());
        this.itemControlManager.updateValues(this.config);
        this.worldControlManager.updateValues(this.config);
    }

    public static void copyResource(URL resourceUrl, File destination) throws IOException {
        URLConnection connection = resourceUrl.openConnection();
        if (!destination.exists()) {
            destination.getParentFile().mkdirs();
            destination.createNewFile();
        }
        int bufferSize = 1024;
        try (InputStream inStream = connection.getInputStream();
             FileOutputStream outStream = new FileOutputStream(destination);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, read);
            }
        }
    }

    public boolean usesVault() {
        return this.usingVault;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public boolean isDisabling() {
        return this.isDisabling;
    }

    public TradeFactory getFactory() {
        return this.factory;
    }

    public TradeConfiguration getConfiguration() {
        return this.config;
    }

    public WorldControlManager getWorldControlManager() {
        return this.worldControlManager;
    }
}

