/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading;

import com.google.common.collect.Maps;
import de.xaniox.simpletrading.Trade;
import de.xaniox.simpletrading.TradeFactory;
import de.xaniox.simpletrading.TradeState;
import de.xaniox.simpletrading.config.TradeConfiguration;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MoveCheckerRunnable
implements Runnable {
    private final TradeConfiguration config;
    private final TradeFactory factory;
    private final Map<Player, Location> lastLocationMap;

    public MoveCheckerRunnable(TradeFactory factory, TradeConfiguration config) {
        this.factory = factory;
        this.lastLocationMap = Maps.newHashMap();
        this.config = config;
    }

    @Override
    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Trade trade = this.factory.getTrade(player);
            if (trade == null || trade.getState() != TradeState.TRADING) {
                if (!this.lastLocationMap.containsKey(player)) continue;
                this.lastLocationMap.remove(player);
                continue;
            }
            if (!this.lastLocationMap.containsKey(player)) {
                this.lastLocationMap.put(player, player.getLocation());
                continue;
            }
            Location last = this.lastLocationMap.get(player);
            Location now = player.getLocation();
            if (last.getWorld() != now.getWorld()) {
                this.factory.stopTrade(trade, Trade.StopCause.LEFT_WORLD, player);
                continue;
            }
            double distanceSquared = trade.getInitiator().getPlayer().getLocation().distanceSquared(trade.getPartner().getPlayer().getLocation());
            int maxDistance = this.config.getMaximumTradeDistance();
            if (maxDistance == -1 || !(distanceSquared > Math.pow(maxDistance, 2.0))) continue;
            this.factory.stopTrade(trade, Trade.StopCause.MOVE, player);
        }
    }
}

