/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading;

import com.google.common.collect.Lists;
import de.xaniox.simpletrading.SetExpFix;
import de.xaniox.simpletrading.SimpleTrading;
import de.xaniox.simpletrading.Trade;
import de.xaniox.simpletrading.TradePlayer;
import de.xaniox.simpletrading.TradeState;
import de.xaniox.simpletrading.config.ItemControlManager;
import de.xaniox.simpletrading.config.TradeConfiguration;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.I18NManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class DefaultTrade
implements Trade {
    private static final int INVENTORY_SIZE = 54;
    private static final int[] SEPERATOR_INDEXES = new int[]{0, 1, 7, 8, 9, 13, 17, 22, 31, 40, 49};
    private static final String[] LEVEL_UP_SEARCH = new String[]{"LEVEL_UP", "PLAYER_LEVELUP"};
    private static final String[] CLICK_SEARCH = new String[]{"UI_BUTTON_CLICK", "CLICK"};
    private static final MaterialData UNCONFIRMED_STATUS_MATERIAL_DATA = new MaterialData(Material.STAINED_GLASS, 14);
    private static final MaterialData CONFIRMED_STATUS_MATERIAL_DATA = new MaterialData(Material.STAINED_GLASS, 5);
    private static final int EXP_INFO_INDEX = 6;
    private static final int ACCEPT_TRADE_INDEX = 3;
    private static final int CONFIRMATION_INFO_INDEX = 4;
    private static final int DECLINE_TRADE_INDEX = 5;
    private static final int MONEY_INFO_INDEX = 2;
    private static final int ADD_MONEY_1_INDEX = 10;
    private static final int ADD_MONEY_2_INDEX = 11;
    private static final int ADD_MONEY_3_INDEX = 12;
    private static final int ADD_EXP_1_INDEX = 14;
    private static final int ADD_EXP_2_INDEX = 15;
    private static final int ADD_EXP_3_INDEX = 16;
    private static final float ADD_PITCH = 1.5f;
    private static final float REMOVE_PITCH = 1.0f;
    private static final DecimalFormat LEVEL_FORMAT = new DecimalFormat("0");
    private final TradePlayer initiator;
    private final TradePlayer partner;
    private final SimpleTrading plugin;
    private final TradeConfiguration config;
    private final I18N i18n = I18NManager.getGlobal();
    private final Economy econ;
    private final ItemControlManager controlManager;
    private StateChangedListener listener;
    private TradeState state;

    public DefaultTrade(Player initiator, Player partner, TradeConfiguration config, Economy econ, ItemControlManager controlManager, SimpleTrading plugin) {
        this.plugin = plugin;
        this.initiator = new TradePlayer(initiator);
        this.partner = new TradePlayer(partner);
        this.config = config;
        this.econ = econ;
        this.controlManager = controlManager;
        this.state = TradeState.REQUESTED;
    }

    @Override
    public TradePlayer getInitiator() {
        return this.initiator;
    }

    @Override
    public TradePlayer getPartner() {
        return this.partner;
    }

    @Override
    public TradeState getState() {
        return this.state;
    }

    public void setListener(StateChangedListener listener) {
        this.listener = listener;
    }

    @Override
    public void setState(TradeState state) {
        this.state = state;
        if (this.listener != null) {
            this.listener.onStateChanged(this, state);
        }
    }

    @Override
    public void accept() {
        int maxInvNameLength = 32;
        String inventoryTitleInitiator = this.config.getInventoryName(this.partner.getName());
        String inventoryTitlePartner = this.config.getInventoryName(this.initiator.getName());
        if (inventoryTitleInitiator.length() > 32) {
            inventoryTitleInitiator = inventoryTitleInitiator.substring(0, 32);
        }
        if (inventoryTitlePartner.length() > 32) {
            inventoryTitlePartner = inventoryTitlePartner.substring(0, 32);
        }
        Inventory initiatorInventory = Bukkit.createInventory(null, (int)54, (String)inventoryTitleInitiator);
        Inventory partnerInventory = Bukkit.createInventory(null, (int)54, (String)inventoryTitlePartner);
        this.initializeInventory(initiatorInventory);
        this.initializeInventory(partnerInventory);
        this.initiator.setInventory(initiatorInventory);
        this.partner.setInventory(partnerInventory);
        this.initiator.getPlayer().openInventory(initiatorInventory);
        this.partner.getPlayer().openInventory(partnerInventory);
        this.setState(TradeState.TRADING);
    }

    private void initializeInventory(Inventory inv) {
        ItemStack addExp3ItemStack;
        ItemStack addExp2ItemStack;
        ItemStack addExp1ItemStack;
        ItemStack expInfoItemStack;
        ItemStack seperator = this.config.getSeperatorBlockData().newItemStack();
        ItemMeta seperatorMeta = seperator.getItemMeta();
        seperatorMeta.setDisplayName(ChatColor.ITALIC.toString());
        seperator.setItemMeta(seperatorMeta);
        for (int seperatorIndex : SEPERATOR_INDEXES) {
            inv.setItem(seperatorIndex, seperator);
        }
        if (this.config.usesXpTrading()) {
            expInfoItemStack = this.config.getXpStatusBlockData().newItemStack();
            ItemMeta expInfoMeta = expInfoItemStack.getItemMeta();
            expInfoMeta.setDisplayName(this.i18n.getString("inventory.exp-info-title"));
            ArrayList expLore = Lists.newArrayList();
            expLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.initiator.getName()).setVariable("offer", "0").toString());
            expLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.partner.getName()).setVariable("offer", "0").toString());
            expInfoMeta.setLore((List)expLore);
            expInfoItemStack.setItemMeta(expInfoMeta);
        } else {
            expInfoItemStack = seperator;
        }
        ItemStack acceptItemStack = this.config.getAcceptBlockData().newItemStack(1);
        ItemMeta acceptMeta = acceptItemStack.getItemMeta();
        acceptMeta.setDisplayName(this.i18n.getString("inventory.accept-trade-title"));
        acceptItemStack.setItemMeta(acceptMeta);
        ItemStack unconfirmedStatusItemStack = UNCONFIRMED_STATUS_MATERIAL_DATA.toItemStack(1);
        ItemMeta unconfirmedStatusMeta = unconfirmedStatusItemStack.getItemMeta();
        unconfirmedStatusMeta.setDisplayName(this.i18n.getString("inventory.trade-status-title"));
        unconfirmedStatusMeta.setLore((List)Lists.newArrayList((Object[])new String[]{this.i18n.getString("inventory.waiting-for-other-player-lore")}));
        unconfirmedStatusItemStack.setItemMeta(unconfirmedStatusMeta);
        ItemStack declineItemStack = this.config.getDeclineBlockData().newItemStack(1);
        ItemMeta declineMeta = declineItemStack.getItemMeta();
        declineMeta.setDisplayName(this.i18n.getString("inventory.decline-trade-title"));
        declineItemStack.setItemMeta(declineMeta);
        ItemStack moneyInfoItemStack = seperator;
        ItemStack addMoney1ItemStack = seperator;
        ItemStack addMoney2ItemStack = seperator;
        ItemStack addMoney3ItemStack = seperator;
        int money1Value = this.config.getMoneyValue1();
        int money2Value = this.config.getMoneyValue2();
        int money3Value = this.config.getMoneyValue3();
        boolean usesVault = this.plugin.usesVault();
        boolean usesMoneyTrading = this.config.usesMoneyTrading();
        if (usesVault && usesMoneyTrading) {
            moneyInfoItemStack = this.config.getMoneyStatusBlockData().newItemStack();
            ItemMeta moneyMeta = moneyInfoItemStack.getItemMeta();
            moneyMeta.setDisplayName(this.i18n.getString("inventory.money-info-title"));
            ArrayList moneyLore = Lists.newArrayList();
            moneyLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.initiator.getName()).setVariable("offer", this.econ.format(0.0)).toString());
            moneyLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.partner.getName()).setVariable("offer", this.econ.format(0.0)).toString());
            moneyMeta.setLore((List)moneyLore);
            moneyInfoItemStack.setItemMeta(moneyMeta);
            ArrayList addMoneyLore = Lists.newArrayList((Object[])this.i18n.getString("inventory.add-money-lore").split("\n"));
            addMoney1ItemStack = this.config.getMoneyAddRemoveBlockData().newItemStack();
            ItemMeta metaMoney1 = addMoney1ItemStack.getItemMeta();
            metaMoney1.setDisplayName(this.i18n.getVarString("inventory.add-remove-money-lore").setVariable("money", this.econ.format((double)money1Value)).toString());
            metaMoney1.setLore((List)addMoneyLore);
            addMoney1ItemStack.setItemMeta(metaMoney1);
            addMoney2ItemStack = this.config.getMoneyAddRemoveBlockData().newItemStack();
            ItemMeta metaMoney2 = addMoney2ItemStack.getItemMeta();
            metaMoney2.setDisplayName(this.i18n.getVarString("inventory.add-remove-money-lore").setVariable("money", this.econ.format((double)money2Value)).toString());
            metaMoney2.setLore((List)addMoneyLore);
            addMoney2ItemStack.setItemMeta(metaMoney2);
            addMoney3ItemStack = this.config.getMoneyAddRemoveBlockData().newItemStack();
            ItemMeta metaMoney3 = addMoney3ItemStack.getItemMeta();
            metaMoney3.setDisplayName(this.i18n.getVarString("inventory.add-remove-money-lore").setVariable("money", this.econ.format((double)money3Value)).toString());
            metaMoney3.setLore((List)addMoneyLore);
            addMoney3ItemStack.setItemMeta(metaMoney3);
        }
        int expValue1 = this.config.getExpValue1();
        int expValue2 = this.config.getExpValue2();
        int expValue3 = this.config.getExpValue3();
        if (this.config.usesXpTrading()) {
            addExp1ItemStack = this.config.getXpAddRemoveBlockData().newItemStack();
            addExp2ItemStack = this.config.getXpAddRemoveBlockData().newItemStack();
            addExp3ItemStack = this.config.getXpAddRemoveBlockData().newItemStack();
            ItemMeta addExpLevelMeta = addExp1ItemStack.getItemMeta();
            addExpLevelMeta.setDisplayName(this.i18n.getVarString("inventory.add-exp-title").setVariable("exp", String.valueOf(expValue1)).toString());
            ArrayList addExpLevelLore = Lists.newArrayList((Object[])this.i18n.getVarString("inventory.add-exp-lore").setVariable("exp", String.valueOf(expValue1)).toString().split("\n"));
            addExpLevelMeta.setLore((List)addExpLevelLore);
            addExp1ItemStack.setItemMeta(addExpLevelMeta);
            addExpLevelMeta = addExp2ItemStack.getItemMeta();
            addExpLevelMeta.setDisplayName(this.i18n.getVarString("inventory.add-exp-title").setVariable("exp", String.valueOf(expValue2)).toString());
            addExpLevelLore = Lists.newArrayList((Object[])this.i18n.getVarString("inventory.add-exp-lore").setVariable("exp", String.valueOf(expValue2)).toString().split("\n"));
            addExpLevelMeta.setLore((List)addExpLevelLore);
            addExp2ItemStack.setItemMeta(addExpLevelMeta);
            addExpLevelMeta = addExp3ItemStack.getItemMeta();
            addExpLevelMeta.setDisplayName(this.i18n.getVarString("inventory.add-exp-title").setVariable("exp", String.valueOf(expValue3)).toString());
            addExpLevelLore = Lists.newArrayList((Object[])this.i18n.getVarString("inventory.add-exp-lore").setVariable("exp", String.valueOf(expValue3)).toString().split("\n"));
            addExpLevelMeta.setLore((List)addExpLevelLore);
            addExp3ItemStack.setItemMeta(addExpLevelMeta);
        } else {
            addExp1ItemStack = seperator;
            addExp2ItemStack = seperator;
            addExp3ItemStack = seperator;
        }
        inv.setItem(6, expInfoItemStack);
        inv.setItem(3, acceptItemStack);
        inv.setItem(4, unconfirmedStatusItemStack);
        inv.setItem(5, declineItemStack);
        inv.setItem(2, moneyInfoItemStack);
        inv.setItem(10, addMoney1ItemStack);
        inv.setItem(11, addMoney2ItemStack);
        inv.setItem(12, addMoney3ItemStack);
        inv.setItem(14, addExp1ItemStack);
        inv.setItem(15, addExp2ItemStack);
        inv.setItem(16, addExp3ItemStack);
    }

    @Override
    public void stop(Trade.StopCause cause, TradePlayer who) {
        TradePlayer other = who == this.initiator ? this.partner : this.initiator;
        TradeState state = this.getState();
        this.setState(TradeState.CANCELLED);
        if (state == TradeState.TRADING) {
            this.reclaimItems(this.initiator);
            this.reclaimItems(this.partner);
            this.initiator.getPlayer().closeInventory();
            this.partner.getPlayer().closeInventory();
            if (!this.plugin.isDisabling()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DefaultTrade.this.initiator.getPlayer().updateInventory();
                        DefaultTrade.this.partner.getPlayer().updateInventory();
                    }
                });
            }
        }
        switch (cause) {
            case DEATH: {
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-death").setVariable("player", who.getName()).toString());
                break;
            }
            case INVENTORY_CLOSE: 
            case DECLINE: {
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-cancel").setVariable("player", who.getName()).toString());
                who.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-decline").setVariable("player", other.getName()).toString());
                break;
            }
            case LEFT_WORLD: {
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-left-world").setVariable("player", who.getName()).toString());
                break;
            }
            case MOVE: {
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-moved-away").setVariable("player", who.getName()).toString());
                break;
            }
            case QUIT: {
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-player-left").setVariable("player", who.getName()).toString());
                break;
            }
            case TIMEOUT: {
                who.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-timeout").setVariable("player", other.getName()).toString());
                other.getPlayer().sendMessage(this.i18n.getVarString("general.cancel-trade-timeout").setVariable("player", who.getName()).toString());
                break;
            }
            case SERVER_SHUTDOWN: {
                who.getPlayer().sendMessage(this.i18n.getString("general.cancel-server-shutdown"));
                other.getPlayer().sendMessage(this.i18n.getString("general.cancel-server-shutdown"));
            }
        }
    }

    private void reclaimItems(TradePlayer player) {
        Inventory inv = player.getInventory();
        for (int y = 2; y < 6; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slot = y * 9 + x;
                ItemStack current = inv.getItem(slot);
                if (current != null) {
                    player.getPlayer().getInventory().addItem(new ItemStack[]{current});
                }
                inv.setItem(slot, null);
            }
        }
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event) {
        TradePlayer tradePlayer;
        Player player = (Player)event.getWhoClicked();
        InventoryType.SlotType type = event.getSlotType();
        if (type != InventoryType.SlotType.CONTAINER && type != InventoryType.SlotType.QUICKBAR) {
            return;
        }
        InventoryView view = event.getView();
        int rawSlot = event.getRawSlot();
        Inventory inventory = view.getTopInventory() != null && rawSlot < view.getTopInventory().getSize() ? view.getTopInventory() : view.getBottomInventory();
        TradePlayer tradePlayer2 = this.initiator.getPlayer() == player ? this.initiator : (tradePlayer = this.partner.getPlayer() == player ? this.partner : null);
        if (tradePlayer == null) {
            return;
        }
        boolean isPlayerInventory = inventory.getType() == InventoryType.PLAYER;
        boolean usesVault = this.plugin.usesVault();
        event.setCancelled(true);
        ClickType clickType = event.getClick();
        int slot = event.getSlot();
        TradeAction action = TradeAction.NOTHING;
        int moneyAdding = 0;
        int expAdding = 0;
        if (isPlayerInventory) {
            action = TradeAction.MOVE_ITEM_TO_TRADE_INVENTORY;
        } else {
            int moneyValue1 = this.config.getMoneyValue1();
            int moneyValue2 = this.config.getMoneyValue2();
            int moneyValue3 = this.config.getMoneyValue3();
            int expValue1 = this.config.getExpValue1();
            int expValue2 = this.config.getExpValue2();
            int expValue3 = this.config.getExpValue3();
            if (slot == 10) {
                moneyAdding = moneyValue1;
                action = TradeAction.ADD_MONEY;
            } else if (slot == 11) {
                moneyAdding = moneyValue2;
                action = TradeAction.ADD_MONEY;
            } else if (slot == 12) {
                moneyAdding = moneyValue3;
                action = TradeAction.ADD_MONEY;
            } else if (slot == 14 && this.config.usesXpTrading()) {
                expAdding = expValue1;
                action = TradeAction.ADD_EXP;
            } else if (slot == 15 && this.config.usesXpTrading()) {
                expAdding = expValue2;
                action = TradeAction.ADD_EXP;
            } else if (slot == 16 && this.config.usesXpTrading()) {
                expAdding = expValue3;
                action = TradeAction.ADD_EXP;
            } else if (slot == 3) {
                action = TradeAction.ACCEPT;
            } else if (slot == 5) {
                action = TradeAction.DECLINE;
            } else if (slot % 9 < 4 && slot / 9 > 1) {
                action = TradeAction.MOVE_ITEM_TO_PLAYER_INVENTORY;
            }
        }
        Sound clickSound = DefaultTrade.getSoundEnumType(CLICK_SEARCH);
        switch (action) {
            case ACCEPT: {
                tradePlayer.setAccepted(true);
                if (!this.initiator.hasAccepted() || !this.partner.hasAccepted()) break;
                this.contractTrade();
                break;
            }
            case DECLINE: {
                tradePlayer.setAccepted(false);
                if (!this.config.isAbortOnDecline()) break;
                this.plugin.getFactory().stopTrade(this, Trade.StopCause.DECLINE, player);
                break;
            }
            case ADD_EXP: {
                int newExpOffer = tradePlayer.getExpOffer();
                if (clickType == ClickType.LEFT) {
                    if ((newExpOffer += expAdding) > SetExpFix.getTotalExperience(player.getPlayer())) {
                        player.sendMessage(this.i18n.getString("general.not-enough-xp"));
                        return;
                    }
                    if (clickSound != null) {
                        player.playSound(player.getLocation(), clickSound, 1.0f, 1.5f);
                    }
                } else if (clickType == ClickType.RIGHT) {
                    if ((newExpOffer -= expAdding) < 0) {
                        player.sendMessage(this.i18n.getString("general.no-xp-offer"));
                        return;
                    }
                    if (clickSound != null) {
                        player.playSound(player.getLocation(), clickSound, 1.0f, 1.0f);
                    }
                }
                tradePlayer.setExpOffer(newExpOffer);
                this.declineAll();
                break;
            }
            case ADD_MONEY: {
                if (!usesVault || !this.config.usesMoneyTrading()) {
                    return;
                }
                int newMoneyOffer = tradePlayer.getMoneyOffer();
                int maxMoneyAmount = this.config.getMaxMoneyTrading();
                if (clickType == ClickType.LEFT) {
                    if ((double)(newMoneyOffer += moneyAdding) > this.econ.getBalance((OfflinePlayer)player)) {
                        player.sendMessage(this.i18n.getString("general.not-enough-money"));
                        return;
                    }
                    if (newMoneyOffer > maxMoneyAmount && maxMoneyAmount != -1) {
                        player.sendMessage(this.i18n.getString("general.max-trade-amount-reached"));
                        return;
                    }
                    if (clickSound != null) {
                        player.playSound(player.getLocation(), clickSound, 1.0f, 1.5f);
                    }
                } else if (clickType == ClickType.RIGHT) {
                    if ((newMoneyOffer -= moneyAdding) < 0) {
                        player.sendMessage(this.i18n.getString("general.no-negative-money-offer"));
                        return;
                    }
                    if (clickSound != null) {
                        player.playSound(player.getLocation(), clickSound, 1.0f, 1.0f);
                    }
                }
                tradePlayer.setMoneyOffer(newMoneyOffer);
                this.declineAll();
                break;
            }
        }
        if (action == TradeAction.MOVE_ITEM_TO_PLAYER_INVENTORY || action == TradeAction.MOVE_ITEM_TO_TRADE_INVENTORY) {
            int newStackAmount;
            ItemStack stack = event.getCurrentItem();
            if (!this.controlManager.isAllowed(stack)) {
                player.sendMessage(this.i18n.getString("general.cannot-trade-item"));
                return;
            }
            if (stack == null || stack.getType() == Material.AIR) {
                return;
            }
            ItemStack stackClone = stack.clone();
            if (clickType == ClickType.LEFT) {
                stackClone.setAmount(stack.getAmount());
                newStackAmount = 0;
            } else if (clickType == ClickType.RIGHT) {
                stackClone.setAmount(1);
                newStackAmount = stack.getAmount() == 1 ? 0 : stack.getAmount() - 1;
            } else {
                return;
            }
            if (action == TradeAction.MOVE_ITEM_TO_TRADE_INVENTORY) {
                int untransferred = this.addToTradeInventory(tradePlayer, stackClone);
                if (untransferred != 0) {
                    stack.setAmount(newStackAmount + untransferred);
                } else {
                    stack.setAmount(newStackAmount);
                }
            } else {
                PlayerInventory inv = player.getInventory();
                HashMap untransferred = inv.addItem(new ItemStack[]{stackClone});
                if (!untransferred.isEmpty()) {
                    stack.setAmount(newStackAmount + ((ItemStack)untransferred.get(0)).getAmount());
                } else {
                    stack.setAmount(newStackAmount);
                }
            }
            if (stack.getAmount() == 0) {
                stack = null;
            }
            event.setCurrentItem(stack);
            this.declineAll();
            this.reflectChanges(tradePlayer);
        }
        this.updateInventoryStatus();
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        TradePlayer tradePlayer;
        Player player = (Player)event.getWhoClicked();
        TradePlayer tradePlayer2 = this.initiator.getPlayer() == player ? this.initiator : (tradePlayer = this.partner.getPlayer() == player ? this.partner : null);
        if (tradePlayer == null) {
            return;
        }
        event.setCancelled(true);
    }

    private void declineAll() {
        this.initiator.setAccepted(false);
        this.partner.setAccepted(false);
    }

    private void contractTrade() {
        Player initiatorPlayer = this.initiator.getPlayer();
        Player partnerPlayer = this.partner.getPlayer();
        if (this.initiator.getMoneyOffer() > 0) {
            this.econ.withdrawPlayer((OfflinePlayer)initiatorPlayer, (double)this.initiator.getMoneyOffer());
            this.econ.depositPlayer((OfflinePlayer)partnerPlayer, (double)this.initiator.getMoneyOffer());
        }
        if (this.partner.getMoneyOffer() > 0) {
            this.econ.withdrawPlayer((OfflinePlayer)partnerPlayer, (double)this.partner.getMoneyOffer());
            this.econ.depositPlayer((OfflinePlayer)initiatorPlayer, (double)this.partner.getMoneyOffer());
        }
        if (this.initiator.getExpOffer() > 0) {
            SetExpFix.setTotalExperience(partnerPlayer, SetExpFix.getTotalExperience(partnerPlayer) + this.initiator.getExpOffer());
            SetExpFix.setTotalExperience(initiatorPlayer, SetExpFix.getTotalExperience(initiatorPlayer) - this.initiator.getExpOffer());
        }
        if (this.partner.getExpOffer() > 0) {
            SetExpFix.setTotalExperience(partnerPlayer, SetExpFix.getTotalExperience(partnerPlayer) - this.partner.getExpOffer());
            SetExpFix.setTotalExperience(initiatorPlayer, SetExpFix.getTotalExperience(initiatorPlayer) + this.partner.getExpOffer());
        }
        this.setState(TradeState.CONTRACTED);
        initiatorPlayer.closeInventory();
        partnerPlayer.closeInventory();
        this.transferTradeItems(this.initiator, this.partner);
        this.transferTradeItems(this.partner, this.initiator);
        initiatorPlayer.updateInventory();
        partnerPlayer.updateInventory();
        Sound levelUpSound = DefaultTrade.getSoundEnumType(LEVEL_UP_SEARCH);
        if (levelUpSound != null) {
            initiatorPlayer.playSound(initiatorPlayer.getLocation(), levelUpSound, 1.0f, 1.0f);
            partnerPlayer.playSound(partnerPlayer.getLocation(), levelUpSound, 1.0f, 1.0f);
        }
        initiatorPlayer.sendMessage(this.i18n.getVarString("general.trade-confirmed").setVariable("player", partnerPlayer.getName()).toString());
        partnerPlayer.sendMessage(this.i18n.getVarString("general.trade-confirmed").setVariable("player", this.initiator.getName()).toString());
    }

    private void transferTradeItems(TradePlayer from, TradePlayer to) {
        Inventory inv = from.getInventory();
        boolean hasUntransferredItems = false;
        for (int y = 2; y < 6; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slot = y * 9 + x;
                ItemStack current = inv.getItem(slot);
                if (current == null) continue;
                HashMap untransferred = to.getPlayer().getInventory().addItem(new ItemStack[]{current});
                if (untransferred.isEmpty()) continue;
                hasUntransferredItems = true;
                for (ItemStack stack : untransferred.values()) {
                    to.getPlayer().getWorld().dropItem(to.getPlayer().getLocation(), stack);
                }
            }
        }
        if (hasUntransferredItems) {
            to.getPlayer().sendMessage(this.i18n.getString("general.inventory-full-items-dropped"));
        }
    }

    private void reflectChanges(TradePlayer player) {
        Inventory inv = player.getInventory();
        Inventory otherInv = player == this.initiator ? this.partner.getInventory() : this.initiator.getInventory();
        for (int y = 2; y < 6; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slot = y * 9 + x;
                int reflectedSlot = y * 9 + (8 - x);
                ItemStack current = inv.getItem(slot);
                otherInv.setItem(reflectedSlot, current);
            }
        }
    }

    private int addToTradeInventory(TradePlayer player, ItemStack stack) {
        Inventory inv = player.getInventory();
        int maxStackSize = Math.max(stack.getAmount(), stack.getMaxStackSize());
        for (int y = 2; y < 6; ++y) {
            for (int x = 0; x < 4; ++x) {
                int amount;
                int slot = y * 9 + x;
                ItemStack current = inv.getItem(slot);
                if (current != null && !current.isSimilar(stack)) continue;
                if (current == null) {
                    current = stack.clone();
                    amount = 0;
                } else if (stack.getAmount() > stack.getMaxStackSize() || (amount = current.getAmount()) >= stack.getMaxStackSize()) continue;
                int newAmount = amount + stack.getAmount();
                if (newAmount > maxStackSize) {
                    newAmount = maxStackSize;
                }
                stack.setAmount(stack.getAmount() - (newAmount - amount));
                current.setAmount(newAmount);
                inv.setItem(slot, current);
                if (stack.getAmount() != 0) continue;
                return 0;
            }
        }
        return stack.getAmount();
    }

    private void updateInventoryStatus() {
        boolean isConfirmed;
        String loreLine;
        ItemStack statusStack;
        boolean usesVault = this.plugin.usesVault();
        if (this.initiator.hasAccepted() || this.partner.hasAccepted()) {
            statusStack = CONFIRMED_STATUS_MATERIAL_DATA.toItemStack(1);
            loreLine = this.i18n.getString("inventory.one-player-accepted");
            isConfirmed = true;
        } else {
            statusStack = UNCONFIRMED_STATUS_MATERIAL_DATA.toItemStack(1);
            loreLine = this.i18n.getString("inventory.waiting-for-other-player-lore");
            isConfirmed = false;
        }
        ItemMeta meta = statusStack.getItemMeta();
        meta.setDisplayName(this.i18n.getVarString("inventory.trade-status-title").setVariable("color", String.valueOf(isConfirmed ? ChatColor.GREEN : ChatColor.RED)).toString());
        meta.setLore((List)Lists.newArrayList((Object[])new String[]{ChatColor.WHITE + loreLine}));
        statusStack.setItemMeta(meta);
        int initiatorDiff = this.getLevelDiff(this.initiator.getPlayer().getLevel(), SetExpFix.getTotalExperience(this.initiator.getPlayer()), this.partner.getExpOffer() - this.initiator.getExpOffer());
        int partnerDiff = this.getLevelDiff(this.partner.getPlayer().getLevel(), SetExpFix.getTotalExperience(this.partner.getPlayer()), this.initiator.getExpOffer() - this.partner.getExpOffer());
        ItemStack expInfoInitiator = this.config.getXpStatusBlockData().newItemStack();
        ItemStack expInfoPartner = this.config.getXpStatusBlockData().newItemStack();
        ItemMeta expInfoMetaInitiator = expInfoInitiator.getItemMeta();
        ItemMeta expInfoMetaPartner = expInfoPartner.getItemMeta();
        expInfoMetaInitiator.setDisplayName(this.i18n.getString("inventory.exp-info-title"));
        expInfoMetaPartner.setDisplayName(this.i18n.getString("inventory.exp-info-title"));
        ArrayList expInfoLore = Lists.newArrayList();
        expInfoLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.initiator.getName()).setVariable("offer", String.valueOf(this.initiator.getExpOffer()) + " XP").toString());
        expInfoLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.partner.getName()).setVariable("offer", String.valueOf(this.partner.getExpOffer()) + " XP").toString());
        expInfoLore.add("");
        ArrayList expInfoLoreInitiator = Lists.newArrayList((Iterable)expInfoLore);
        ArrayList expInfoLorePartner = Lists.newArrayList((Iterable)expInfoLore);
        expInfoLoreInitiator.add(this.i18n.getVarString("inventory.level-info").setVariable("level-diff", LEVEL_FORMAT.format(initiatorDiff)).toString());
        expInfoLorePartner.add(this.i18n.getVarString("inventory.level-info").setVariable("level-diff", LEVEL_FORMAT.format(partnerDiff)).toString());
        expInfoMetaInitiator.setLore((List)expInfoLoreInitiator);
        expInfoMetaPartner.setLore((List)expInfoLorePartner);
        expInfoInitiator.setItemMeta(expInfoMetaInitiator);
        expInfoPartner.setItemMeta(expInfoMetaPartner);
        if (usesVault && this.config.usesMoneyTrading()) {
            ItemStack moneyInfo = this.config.getMoneyStatusBlockData().newItemStack();
            ItemMeta moneyInfoMeta = moneyInfo.getItemMeta();
            moneyInfoMeta.setDisplayName(this.i18n.getString("inventory.money-info-title"));
            ArrayList moneyInfoLore = Lists.newArrayList();
            moneyInfoLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.initiator.getName()).setVariable("offer", this.econ.format((double)this.initiator.getMoneyOffer())).toString());
            moneyInfoLore.add(this.i18n.getVarString("inventory.offer-lore").setVariable("player", this.partner.getName()).setVariable("offer", this.econ.format((double)this.partner.getMoneyOffer())).toString());
            moneyInfoMeta.setLore((List)moneyInfoLore);
            moneyInfo.setItemMeta(moneyInfoMeta);
            this.initiator.getInventory().setItem(2, moneyInfo);
            this.partner.getInventory().setItem(2, moneyInfo);
        }
        this.initiator.getInventory().setItem(4, statusStack);
        this.partner.getInventory().setItem(4, statusStack);
        if (this.config.usesXpTrading()) {
            this.initiator.getInventory().setItem(6, expInfoInitiator);
            this.partner.getInventory().setItem(6, expInfoPartner);
        }
    }

    private int getLevelDiff(int levelBase, int expBase, int expDiff) {
        int totalExp = expBase + expDiff;
        if (expDiff == 0) {
            return 0;
        }
        int level = totalExp < 394 ? (int)(Math.sqrt(totalExp + 9) - 3.0) : (totalExp >= 394 && totalExp < 1628 ? (int)(0.632456 * (Math.sqrt((double)totalExp - 195.975) + 12.8072)) : (int)(0.471405 * (Math.sqrt((double)totalExp - 752.986) + 38.3016)));
        return level - levelBase;
    }

    public static Sound getSoundEnumType(String ... searchStrings) {
        Sound[] sounds;
        for (Sound sound : sounds = Sound.values()) {
            for (String search : searchStrings) {
                if (!sound.name().toUpperCase().contains(search)) continue;
                return sound;
            }
        }
        return null;
    }

    static {
        LEVEL_FORMAT.setPositivePrefix("+");
    }

    public static interface StateChangedListener {
        public void onStateChanged(Trade var1, TradeState var2);
    }

    private static enum TradeAction {
        ADD_MONEY,
        ADD_EXP,
        ACCEPT,
        DECLINE,
        MOVE_ITEM_TO_PLAYER_INVENTORY,
        MOVE_ITEM_TO_TRADE_INVENTORY,
        NOTHING;

    }
}

