/*
 * Decompiled with CFR 0.152.
 */
package de.xaniox.simpletrading;

import com.google.common.collect.Lists;
import de.xaniox.simpletrading.Permissions;
import de.xaniox.simpletrading.SimpleTrading;
import de.xaniox.simpletrading.Trade;
import de.xaniox.simpletrading.TradeFactory;
import de.xaniox.simpletrading.config.WorldControlManager;
import de.xaniox.simpletrading.i18n.I18N;
import de.xaniox.simpletrading.i18n.I18NManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.PluginDescriptionFile;

public class CommandTrade
implements CommandExecutor {
    private final I18N i18n = I18NManager.getGlobal();
    private SimpleTrading main;

    public CommandTrade(SimpleTrading main) {
        this.main = main;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("trade")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.getString("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        TradeFactory factory = this.main.getFactory();
        WorldControlManager worldControlManager = this.main.getWorldControlManager();
        if (args.length < 1) {
            player.sendMessage(this.i18n.getVarString("command.usage").setVariable("usage", "/trade <player>").toString());
            return true;
        }
        if (args[0].equalsIgnoreCase("accept") || args[0].equalsIgnoreCase("a")) {
            if (!player.hasPermission(Permissions.TRADE_ACCEPT.getPermission())) {
                player.sendMessage(this.i18n.getString("command.insufficient-permission"));
                return true;
            }
            Trade trade = factory.getTrade(player);
            if (trade == null || trade.getPartner().getPlayer() != player) {
                player.sendMessage(this.i18n.getVarString("general.no-pending-requests").setVariable("player", player.getName()).toString());
                return true;
            }
            Player other = trade.getInitiator().getPlayer() == player ? trade.getPartner().getPlayer() : trade.getInitiator().getPlayer();
            int maxDistance = this.main.getConfiguration().getMaximumTradeDistance();
            if ((player.getWorld() != other.getWorld() || player.getLocation().distanceSquared(other.getLocation()) > (double)(maxDistance * 2)) && maxDistance != -1) {
                player.sendMessage(this.i18n.getString("command.partner-too-far-away"));
                return true;
            }
            if (!worldControlManager.isAllowed(player.getWorld())) {
                player.sendMessage(this.i18n.getString("command.cannot-trade-in-world"));
                return true;
            }
            if (!worldControlManager.isAllowed(other.getWorld())) {
                player.sendMessage(this.i18n.getString("command.cannot-trade-in-world-partner"));
                return true;
            }
            factory.acceptTrade(player);
        } else if (args[0].equalsIgnoreCase("decline") || args[0].equalsIgnoreCase("d")) {
            if (!player.hasPermission(Permissions.TRADE_DENY.getPermission())) {
                player.sendMessage(this.i18n.getString("command.insufficient-permission"));
                return true;
            }
            Trade trade = factory.getTrade(player);
            if (trade == null || trade.getPartner().getPlayer() != player) {
                player.sendMessage(this.i18n.getVarString("general.no-pending-requests").setVariable("player", player.getName()).toString());
                return true;
            }
            factory.declineTrade(player);
            trade.getInitiator().getPlayer().sendMessage(this.i18n.getVarString("general.trade-request-declined").setVariable("player", player.getName()).toString());
            player.sendMessage(this.i18n.getVarString("general.trade-declined").setVariable("player", trade.getInitiator().getName()).toString());
        } else if (args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission(Permissions.RELOAD.getPermission())) {
                player.sendMessage(this.i18n.getString("command.insufficient-permission"));
                return true;
            }
            this.main.reload();
            player.sendMessage(this.i18n.getString("command.configurations-reloaded"));
        } else if (args[0].equalsIgnoreCase("sign")) {
            List<String> lores;
            if (!player.hasPermission(Permissions.SIGN.getPermission())) {
                player.sendMessage(this.i18n.getString("command.insufficient-permission"));
                return true;
            }
            int loreIndex = 0;
            if (args.length > 1) {
                try {
                    loreIndex = Integer.parseInt(args[1]) - 1;
                }
                catch (NumberFormatException nfe) {
                    player.sendMessage(this.i18n.getVarString("command.not-a-number").setVariable("number", args[1]).toString());
                    return true;
                }
            }
            if (loreIndex >= (lores = this.main.getConfiguration().getItemControlLoreList()).size()) {
                player.sendMessage(this.i18n.getVarString("command.no-lore-with-number").setVariable("number", String.valueOf(loreIndex + 1)).toString());
                return true;
            }
            String lore = lores.get(loreIndex);
            ItemStack stack = player.getItemInHand();
            if (stack == null) {
                player.sendMessage(this.i18n.getString("command.no-item-in-hand"));
                return true;
            }
            ItemMeta meta = stack.getItemMeta();
            List itemLore = meta.getLore();
            if (itemLore == null) {
                itemLore = Lists.newArrayList();
            }
            itemLore.add(lore);
            meta.setLore(itemLore);
            stack.setItemMeta(meta);
            player.setItemInHand(stack);
            player.sendMessage(this.i18n.getString("command.lore-applied"));
        } else if (args[0].equalsIgnoreCase("version")) {
            PluginDescriptionFile desc = this.main.getDescription();
            player.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "SimpleTrading " + ChatColor.GREEN + "v" + desc.getVersion() + ChatColor.GRAY + " by " + ChatColor.GREEN + "Matze" + ChatColor.GRAY + " (@xaniox/@matzefratze123)");
        } else {
            if (!player.hasPermission(Permissions.TRADE_INITIATE.getPermission())) {
                player.sendMessage(this.i18n.getString("command.insufficient-permission"));
                return true;
            }
            String partnerName = args[0];
            Player tradePartner = Bukkit.getPlayer((String)partnerName);
            if (tradePartner == null) {
                player.sendMessage(this.i18n.getVarString("command.player-not-found").setVariable("player", partnerName).toString());
                return true;
            }
            if (tradePartner == player) {
                player.sendMessage(this.i18n.getString("command.no-self-trade"));
                return true;
            }
            if (!(this.main.getConfiguration().allowsCreativeTrading() || player.getGameMode() != GameMode.CREATIVE && tradePartner.getGameMode() != GameMode.CREATIVE)) {
                player.sendMessage(this.i18n.getVarString("general.partner-in-creative").setVariable("player", tradePartner.getName()).toString());
                return true;
            }
            int maxDistance = this.main.getConfiguration().getMaximumTradeDistance();
            if ((player.getWorld() != tradePartner.getWorld() || player.getLocation().distanceSquared(tradePartner.getLocation()) > (double)(maxDistance * 2)) && maxDistance != -1) {
                player.sendMessage(this.i18n.getString("command.partner-too-far-away"));
                return true;
            }
            if (!worldControlManager.isAllowed(player.getWorld())) {
                player.sendMessage(this.i18n.getString("command.cannot-trade-in-world"));
                return true;
            }
            if (!worldControlManager.isAllowed(tradePartner.getWorld())) {
                player.sendMessage(this.i18n.getString("command.cannot-trade-in-world-partner"));
                return true;
            }
            factory.initiateTrade(player, tradePartner);
        }
        return true;
    }
}

