/*
 * Decompiled with CFR 0.152.
 */
package hu.Gfegyver.EndPortal;

import hu.Gfegyver.EndPortal.Main;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    File DataFile;
    YamlConfiguration config;
    Main main;
    public Map<String, Location> Worlds;

    public Config(Main main) {
        this.main = main;
        this.DataFile = new File(main.getDataFolder(), "config.yml");
        if (!this.DataFile.exists()) {
            this.config = YamlConfiguration.loadConfiguration((InputStream)((Object)((Object)main)).getClass().getClassLoader().getResourceAsStream("config.yml"));
            try {
                this.config.save(this.DataFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.DataFile);
        this.load();
    }

    public void load() {
        this.Worlds = new HashMap<String, Location>();
        try {
            for (String s : this.config.getKeys(false)) {
                this.Worlds.put(s, (Location)this.config.get(s));
            }
        }
        catch (Exception e) {
            System.out.println("[PortalPosition] Error, couldn't load config.yml!");
        }
    }

    public boolean containsWorld(String world) {
        return this.Worlds.containsKey(world);
    }

    public Location getLocation(String world) {
        if (this.containsWorld(world)) {
            return this.Worlds.get(world);
        }
        return null;
    }

    public void addLocation(Location l) {
        this.Worlds.put(l.getWorld().getName(), l);
        this.config.set(l.getWorld().getName(), (Object)l);
    }

    public void save() {
        try {
            this.config.save(this.DataFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(String world) {
        this.Worlds.remove(world);
        this.config.set(world, null);
    }
}

