/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Furnace;
import ovh.socram.bukkit.solarfurnace.ChunkNotLoadedException;
import ovh.socram.bukkit.solarfurnace.InvalidSolarFurnaceException;
import ovh.socram.bukkit.solarfurnace.SFPlugin;
import ovh.socram.bukkit.solarfurnace.UnsupportedBukkitException;

public class SolarFurnace {
    private static final BlockFace[] PANEL_SIDES = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private SFPlugin plugin;
    private Block furnaceBlock;

    public SolarFurnace(SFPlugin plugin, Block furnaceBlock) {
        this.plugin = plugin;
        this.furnaceBlock = furnaceBlock;
    }

    public void check() throws ChunkNotLoadedException, InvalidSolarFurnaceException {
        this.checkWorld();
        this.checkFurnace();
        this.checkPanels();
    }

    public void checkWorld() throws InvalidSolarFurnaceException {
        if (this.furnaceBlock.getWorld().getEnvironment() != World.Environment.NORMAL) {
            throw new InvalidSolarFurnaceException("Invalid enviroment");
        }
    }

    public void checkFurnace() throws ChunkNotLoadedException, InvalidSolarFurnaceException {
        if (!this.furnaceBlock.getChunk().isLoaded()) {
            throw new ChunkNotLoadedException("Cannot check furnace");
        }
        Material furnaceMaterial = this.furnaceBlock.getType();
        if (furnaceMaterial != Material.FURNACE && furnaceMaterial != Material.BURNING_FURNACE) {
            throw new InvalidSolarFurnaceException("No furnace found");
        }
    }

    public void checkPanels() throws ChunkNotLoadedException, InvalidSolarFurnaceException {
        for (int i = 0; i < PANEL_SIDES.length; ++i) {
            Block panelBlock = this.furnaceBlock.getRelative(PANEL_SIDES[i]);
            if (panelBlock.getChunk().isLoaded()) {
                throw new ChunkNotLoadedException("Cannot check panels");
            }
            if (panelBlock.getType() != Material.DAYLIGHT_DETECTOR) continue;
            return;
        }
        throw new InvalidSolarFurnaceException("No solar panel found");
    }

    public void doTick() throws ChunkNotLoadedException, InvalidSolarFurnaceException, UnsupportedBukkitException {
        this.checkFurnace();
        Furnace furnace = (Furnace)this.furnaceBlock.getState();
        if (furnace.getInventory().getSmelting() == null) {
            return;
        }
        if (this.getPanelsLight() < 15) {
            return;
        }
        short remainingTicks = furnace.getBurnTime();
        if (remainingTicks == 0) {
            furnace.setBurnTime((short)2);
            this.plugin.getUpdater().setBurning(this.furnaceBlock);
        } else {
            furnace.setBurnTime((short)(remainingTicks + 1));
        }
    }

    private int getPanelsLight() throws ChunkNotLoadedException, InvalidSolarFurnaceException {
        int intensity = -1;
        boolean chunkUnloaded = false;
        for (int i = 0; i < PANEL_SIDES.length; ++i) {
            Block panelBlock = this.furnaceBlock.getRelative(PANEL_SIDES[i]);
            if (!panelBlock.getChunk().isLoaded()) {
                chunkUnloaded = true;
                continue;
            }
            if (panelBlock.getType() != Material.DAYLIGHT_DETECTOR) continue;
            intensity = Math.max(intensity, panelBlock.getLightFromSky());
        }
        if (intensity < 0) {
            if (chunkUnloaded) {
                throw new ChunkNotLoadedException("Cannot check panels");
            }
            throw new InvalidSolarFurnaceException("No solar panel found");
        }
        return intensity;
    }

    public Block getFurnaceBlock() {
        return this.furnaceBlock;
    }
}

