/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import java.io.IOException;
import org.bukkit.Server;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import ovh.socram.bukkit.solarfurnace.CraftVersion;
import ovh.socram.bukkit.solarfurnace.CreateListener;
import ovh.socram.bukkit.solarfurnace.FuelTask;
import ovh.socram.bukkit.solarfurnace.FurnaceDatabase;
import ovh.socram.bukkit.solarfurnace.FurnaceUpdater;
import ovh.socram.bukkit.solarfurnace.UnsupportedBukkitException;
import ovh.socram.bukkit.solarfurnace.WorldListener;
import ovh.socram.bukkit.solarfurnace.metrics.MetricsLite;

public class SFPlugin
extends JavaPlugin {
    private FurnaceDatabase furnaces;
    private FurnaceUpdater updater;
    private Permission createPermission = new Permission("solarfurnace.create", "Allows creation of solar furnaces", PermissionDefault.TRUE);

    public void onEnable() {
        Server server = this.getServer();
        PluginManager pm = server.getPluginManager();
        pm.addPermission(this.createPermission);
        CraftVersion craftVersion = new CraftVersion(server);
        this.getLogger().info("Detected Bukkit version: " + craftVersion);
        try {
            this.updater = new FurnaceUpdater(craftVersion);
        }
        catch (UnsupportedBukkitException exception) {
            this.getLogger().severe("Bukkit version not supported");
            pm.disablePlugin((Plugin)this);
            return;
        }
        this.furnaces = new FurnaceDatabase(this);
        this.furnaces.loadFurnaces();
        new CreateListener(this);
        new WorldListener(this);
        new FuelTask(this);
        try {
            new MetricsLite((Plugin)this).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.getServer().getPluginManager().removePermission(this.createPermission);
        if (this.furnaces != null) {
            this.furnaces.unloadFurnaces();
        }
    }

    public FurnaceDatabase getFurnaces() {
        return this.furnaces;
    }

    public FurnaceUpdater getUpdater() {
        return this.updater;
    }

    public Permission getCreatePermission() {
        return this.createPermission;
    }
}

