/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import ovh.socram.bukkit.solarfurnace.CraftVersion;
import ovh.socram.bukkit.solarfurnace.UnsupportedBukkitException;

public class FurnaceUpdater {
    private final CraftVersion craftVersion;
    private final boolean fixed;
    private static final CraftVersion CRAFT_FIXED = new CraftVersion(CraftVersion.Flavour.CRAFTBUKKIT, 1, 8, 2);

    public FurnaceUpdater(CraftVersion craftVersion) throws UnsupportedBukkitException {
        this.craftVersion = craftVersion;
        this.fixed = FurnaceUpdater.isVersionFixed(craftVersion);
        if (this.fixed) {
            return;
        }
        CraftVersion.Flavour flavour = craftVersion.getFlavour();
        if (flavour == CraftVersion.Flavour.CRAFTBUKKIT) {
            int major = craftVersion.getMajor();
            int minor = craftVersion.getMinor();
            int revision = craftVersion.getRevision();
            if (major == 1 && minor == 5 && revision >= 1 && revision <= 3) {
                return;
            }
            if (major == 1 && minor == 6 && revision <= 3) {
                return;
            }
        }
        throw new UnsupportedBukkitException(craftVersion);
    }

    public void update(Furnace furnace) throws UnsupportedBukkitException {
        this.update(furnace.getBlock(), furnace.getBurnTime() > 0);
    }

    public void setIdle(Block furnace) throws UnsupportedBukkitException {
        this.update(furnace, false);
    }

    public void setBurning(Block furnace) throws UnsupportedBukkitException {
        this.update(furnace, true);
    }

    public void update(Block furnace, boolean burn) throws UnsupportedBukkitException {
        if (this.fixed) {
            return;
        }
        int x = furnace.getX();
        int y = furnace.getY();
        int z = furnace.getZ();
        int block = burn ? Material.BURNING_FURNACE.getId() : Material.FURNACE.getId();
        try {
            World craftWorld = furnace.getWorld();
            Object nmsWorld = craftWorld.getClass().getMethod("getHandle", new Class[0]).invoke((Object)craftWorld, new Object[0]);
            Class<?> nmsWorldClass = nmsWorld.getClass();
            Object nmsChunk = nmsWorldClass.getMethod("getChunkAtWorldCoords", Integer.TYPE, Integer.TYPE).invoke(nmsWorld, x, z);
            Class<?> nmsChunkClass = nmsChunk.getClass();
            Object nmsChunkSection = ((Object[])nmsChunkClass.getMethod("i", new Class[0]).invoke(nmsChunk, new Object[0]))[y >> 4];
            String setTypeIdMethodName = this.craftVersion.getMajor() == 1 && this.craftVersion.getMinor() == 5 && this.craftVersion.getRevision() < 3 ? "a" : "setTypeId";
            nmsChunkSection.getClass().getMethod(setTypeIdMethodName, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(nmsChunkSection, x & 0xF, y & 0xF, z & 0xF, block);
            nmsChunkClass.getField("l").setBoolean(nmsChunk, true);
            nmsWorldClass.getMethod("A", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(nmsWorld, x, y, z);
            nmsWorldClass.getMethod("notify", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(nmsWorld, x, y, z);
        }
        catch (Exception ex) {
            throw new UnsupportedBukkitException(this.craftVersion, "Unexpected exception. Please notify developers about this", ex);
        }
    }

    public static boolean isVersionFixed(CraftVersion craftVersion) {
        CraftVersion.Flavour flavour = craftVersion.getFlavour();
        if (flavour == CraftVersion.Flavour.SPORTBUKKIT) {
            return true;
        }
        if (flavour == CraftVersion.Flavour.CRAFTBUKKIT) {
            return craftVersion.compareTo(CRAFT_FIXED) >= 0;
        }
        return false;
    }

    public CraftVersion getCraftVersion() {
        return this.craftVersion;
    }
}

