/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import ovh.socram.bukkit.solarfurnace.ChunkNotLoadedException;
import ovh.socram.bukkit.solarfurnace.InvalidSolarFurnaceException;
import ovh.socram.bukkit.solarfurnace.SFPlugin;
import ovh.socram.bukkit.solarfurnace.SolarFurnace;

public class FurnaceDatabase {
    private HashMap<World, ArrayList<SolarFurnace>> furnaces = new HashMap();
    private SFPlugin plugin;

    public FurnaceDatabase(SFPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadFurnaces() {
        Iterator it = this.plugin.getServer().getWorlds().iterator();
        while (it.hasNext()) {
            this.loadWorldFurnaces((World)it.next());
        }
    }

    public void unloadFurnaces() {
        Iterator<World> it = this.furnaces.keySet().iterator();
        while (it.hasNext()) {
            this.saveWorldFurnaces(it.next());
            it.remove();
        }
    }

    public void loadWorldFurnaces(World world) {
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        ArrayList<SolarFurnace> worldFurnaces = new ArrayList<SolarFurnace>();
        this.furnaces.put(world, worldFurnaces);
        File file = new File(world.getWorldFolder(), "solarfurnace.bin");
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.plugin.getLogger().info("No solar furnace data found for world " + world.getName());
            return;
        }
        DataInputStream dataStream = new DataInputStream(fileStream);
        try {
            while (true) {
                int x = dataStream.readInt();
                int y = dataStream.readUnsignedByte();
                int z = dataStream.readInt();
                Block furnaceBlock = world.getBlockAt(x, y, z);
                SolarFurnace solarFurnace = new SolarFurnace(this.plugin, furnaceBlock);
                try {
                    solarFurnace.check();
                }
                catch (ChunkNotLoadedException chunkNotLoadedException) {
                }
                catch (InvalidSolarFurnaceException e) {
                    continue;
                }
                worldFurnaces.add(solarFurnace);
            }
        }
        catch (IOException e) {
            try {
                fileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.plugin.getLogger().info("Found " + worldFurnaces.size() + " solar furnace(s) in world " + world.getName());
            return;
        }
    }

    private void saveWorldFurnaces(World world) {
        ArrayList<SolarFurnace> worldFurnaces = this.furnaces.get(world);
        File file = new File(world.getWorldFolder(), "solarfurnace.bin");
        FileOutputStream fileStream = null;
        try {
            fileStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            this.plugin.getLogger().warning("Unable to save furnace data for world " + world.getName());
            return;
        }
        DataOutputStream dataStream = new DataOutputStream(fileStream);
        Iterator<SolarFurnace> it = worldFurnaces.iterator();
        while (it.hasNext()) {
            Block furnaceBlock = it.next().getFurnaceBlock();
            try {
                dataStream.writeInt(furnaceBlock.getX());
                dataStream.writeByte(furnaceBlock.getY());
                dataStream.writeInt(furnaceBlock.getZ());
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Unexpected I/O error while saving furnace data for world " + world.getName());
                break;
            }
        }
        try {
            fileStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.plugin.getLogger().info("Saved " + worldFurnaces.size() + " solar furnace(s) in world " + world.getName());
    }

    public void unloadWorldFurnaces(World world) {
        this.saveWorldFurnaces(world);
        this.furnaces.remove(world);
    }

    public void add(SolarFurnace furnace) {
        this.furnaces.get(furnace.getFurnaceBlock().getWorld()).add(furnace);
    }

    public void remove(SolarFurnace furnace) {
        this.furnaces.get(furnace.getFurnaceBlock().getWorld()).remove(furnace);
    }

    public Set<World> getWorlds() {
        return this.furnaces.keySet();
    }

    public ArrayList<SolarFurnace> getFurnacesInWorld(World world) {
        return this.furnaces.get(world);
    }

    public HashMap<World, ArrayList<SolarFurnace>> getFurnaces() {
        return this.furnaces;
    }
}

