/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import java.util.Iterator;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ovh.socram.bukkit.solarfurnace.ChunkNotLoadedException;
import ovh.socram.bukkit.solarfurnace.FurnaceDatabase;
import ovh.socram.bukkit.solarfurnace.InvalidSolarFurnaceException;
import ovh.socram.bukkit.solarfurnace.SFPlugin;
import ovh.socram.bukkit.solarfurnace.SolarFurnace;
import ovh.socram.bukkit.solarfurnace.UnsupportedBukkitException;

public class FuelTask
extends BukkitRunnable {
    private SFPlugin plugin;

    public FuelTask(SFPlugin plugin) {
        this.plugin = plugin;
        this.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    public void run() {
        FurnaceDatabase furnaces = this.plugin.getFurnaces();
        for (World world : furnaces.getWorlds()) {
            if (world.getTime() > 12000L) continue;
            Iterator<SolarFurnace> furnaceIterator = furnaces.getFurnacesInWorld(world).iterator();
            while (furnaceIterator.hasNext()) {
                SolarFurnace furnace = furnaceIterator.next();
                try {
                    furnace.doTick();
                }
                catch (ChunkNotLoadedException chunkNotLoadedException) {
                }
                catch (InvalidSolarFurnaceException e) {
                    furnaceIterator.remove();
                }
                catch (UnsupportedBukkitException e) {
                    this.plugin.getLogger().severe("Unexpected exception in FurnaceUpdater");
                    this.plugin.getLogger().severe("Detected version: " + e.getCraftVersion());
                    this.plugin.getLogger().log(Level.SEVERE, "Exception cause:", e.getCause());
                    this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
                    return;
                }
            }
        }
    }
}

