/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import ovh.socram.bukkit.solarfurnace.ChunkNotLoadedException;
import ovh.socram.bukkit.solarfurnace.FurnaceDatabase;
import ovh.socram.bukkit.solarfurnace.InvalidSolarFurnaceException;
import ovh.socram.bukkit.solarfurnace.SFPlugin;
import ovh.socram.bukkit.solarfurnace.SolarFurnace;

public class CreateListener
implements Listener {
    private static final BlockFace[] FURNACE_SIDES = new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private SFPlugin plugin;

    public CreateListener(SFPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.getPlayer().hasPermission(this.plugin.getCreatePermission())) {
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        if (material == Material.FURNACE || material == Material.BURNING_FURNACE) {
            SolarFurnace solarFurnace = new SolarFurnace(this.plugin, block);
            try {
                solarFurnace.checkWorld();
                solarFurnace.checkPanels();
            }
            catch (ChunkNotLoadedException chunkNotLoadedException) {
            }
            catch (InvalidSolarFurnaceException e) {
                return;
            }
            this.plugin.getFurnaces().add(solarFurnace);
        } else if (material == Material.DAYLIGHT_DETECTOR) {
            FurnaceDatabase database = this.plugin.getFurnaces();
            for (BlockFace face : FURNACE_SIDES) {
                SolarFurnace solarFurnace = new SolarFurnace(this.plugin, block.getRelative(face));
                try {
                    solarFurnace.checkWorld();
                    solarFurnace.checkFurnace();
                }
                catch (ChunkNotLoadedException chunkNotLoadedException) {
                }
                catch (InvalidSolarFurnaceException e) {
                    continue;
                }
                database.add(solarFurnace);
            }
        }
    }
}

