/*
 * Decompiled with CFR 0.152.
 */
package ovh.socram.bukkit.solarfurnace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Server;

public class CraftVersion
implements Comparable<CraftVersion> {
    public static final CraftVersion UNKNOWN_VERSION = new CraftVersion(Flavour.UNKNOWN, 0, 0, 0);
    private static final Pattern CRAFT_PATTERN = Pattern.compile("^org\\.bukkit\\.craftbukkit\\.v([0-9]+)_([0-9]+)_R([0-9]+)\\.CraftServer$");
    private final int major;
    private final int minor;
    private final int revision;
    private final Flavour flavour;

    public CraftVersion(Server server) {
        String serverClassPath = server.getClass().getCanonicalName();
        Matcher craftMatcher = CRAFT_PATTERN.matcher(serverClassPath);
        if (!craftMatcher.matches()) {
            throw new RuntimeException("Could not parse server class: " + serverClassPath);
        }
        this.flavour = Flavour.byName(server.getName());
        this.major = Integer.valueOf(craftMatcher.group(1));
        this.minor = Integer.valueOf(craftMatcher.group(2));
        this.revision = Integer.valueOf(craftMatcher.group(3));
    }

    public CraftVersion(Flavour flavour, int major, int minor, int revision) {
        this.flavour = flavour;
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public String toString() {
        return (Object)((Object)this.flavour) + " " + this.major + "." + this.minor + "R" + this.revision;
    }

    @Override
    public int compareTo(CraftVersion other) {
        int otherMajor = other.getMajor();
        if (this.major < otherMajor) {
            return -1;
        }
        if (this.major > otherMajor) {
            return 1;
        }
        int otherMinor = other.getMinor();
        if (this.minor < otherMinor) {
            return -1;
        }
        if (this.minor > otherMinor) {
            return 1;
        }
        int otherRevision = other.getRevision();
        if (this.revision < otherRevision) {
            return -1;
        }
        if (this.revision > otherRevision) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public Flavour getFlavour() {
        return this.flavour;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftVersion)) {
            return false;
        }
        CraftVersion other = (CraftVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        Flavour this$flavour = this.getFlavour();
        Flavour other$flavour = other.getFlavour();
        return !(this$flavour == null ? other$flavour != null : !((Object)((Object)this$flavour)).equals((Object)other$flavour));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CraftVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getRevision();
        Flavour $flavour = this.getFlavour();
        result = result * 59 + ($flavour == null ? 43 : ((Object)((Object)$flavour)).hashCode());
        return result;
    }

    public static enum Flavour {
        UNKNOWN("Unknown"),
        CRAFTBUKKIT("CraftBukkit"),
        SPORTBUKKIT("SportBukkit");

        private final String niceName;

        private Flavour(String niceName) {
            this.niceName = niceName;
        }

        public String toString() {
            return this.niceName;
        }

        public static Flavour byName(String name) {
            for (Flavour flavour : Flavour.values()) {
                if (!flavour.niceName.equals(name)) continue;
                return flavour;
            }
            return UNKNOWN;
        }
    }
}

