/*
 * Decompiled with CFR 0.152.
 */
package me.jailb8_.rot13;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    Server s = this.getServer();
    private Set<UUID> busy = new HashSet<UUID>();

    public void onEnable() {
        PluginManager pm = this.s.getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (this.getConfig().getInt("ROT") == 13 || this.getConfig().getInt("ROT") == 47) {
            this.s.getLogger().log(Level.INFO, "Loaded Successfully. Will use ROT" + this.getConfig().getInt("ROT"));
        } else {
            this.s.getLogger().log(Level.SEVERE, "Invalid ROT format provided. Plugin will disable. Edit in config.");
            pm.disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        UUID id = p.getUniqueId();
        String message = e.getMessage();
        if (this.getConfig().getBoolean("ROT-BY-DEFAULT")) {
            if (this.busy.contains(id)) {
                this.busy.remove(id);
                return;
            }
            this.busy.add(id);
            if (this.getConfig().getInt("ROT") == 13) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < message.length()) {
                    char c = message.charAt(i);
                    if (c >= 'a' && c <= 'm') {
                        c = (char)(c + 13);
                    } else if (c >= 'A' && c <= 'M') {
                        c = (char)(c + 13);
                    } else if (c >= 'n' && c <= 'z') {
                        c = (char)(c - 13);
                    } else if (c >= 'N' && c <= 'Z') {
                        c = (char)(c - 13);
                    }
                    sb.append(c);
                    ++i;
                }
                p.chat(sb.toString());
                this.s.getLogger().info("[ROT13] " + sb.toString() + " : " + message);
                e.setCancelled(true);
            } else if (this.getConfig().getInt("ROT") == 47) {
                int length = message.length();
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < length) {
                    char c = message.charAt(i);
                    if (c != ' ' && (c = (char)(c + 47)) > '~') {
                        c = (char)(c - 94);
                    }
                    result.append(c);
                    ++i;
                }
                p.chat(result.toString());
                this.s.getLogger().info("[ROT47] " + result.toString() + " : " + message);
                e.setCancelled(true);
            } else {
                this.s.getLogger().severe("ROT IS NOT DEFINED CORRECTLY FOR CHAT. PLEASE USE 13 OR 47.");
            }
        }
    }
}

