/*
 * Decompiled with CFR 0.152.
 */
package me.trolking1.BlockWars.Events;

import java.util.ArrayList;
import me.trolking1.BlockWars.Arena;
import me.trolking1.BlockWars.ArenaManager;
import me.trolking1.BlockWars.ConfigManager;
import me.trolking1.BlockWars.Main;
import me.trolking1.BlockWars.MessageManager;
import me.trolking1.BlockWars.SignCreation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class Signs
implements Listener {
    MessageManager mm = MessageManager.getInstance();
    ConfigManager cm = ConfigManager.getInstance();
    private ArrayList<SignCreation> signs = new ArrayList();

    public Signs() {
        for (String key : this.cm.getSign().getKeys(false)) {
            ConfigurationSection s = (ConfigurationSection)this.cm.getSign().get(key);
            Location loc = Main.loadLocation(s.getConfigurationSection("location"));
            Arena arena = ArenaManager.getInstance().getArena(s.getString("arena"));
            if (loc.getBlock() == null || !(loc.getBlock().getState() instanceof Sign)) {
                this.cm.getSign().set(key, null);
                System.err.println("Removed broken sign at location " + loc + ".");
                continue;
            }
            if (arena == null) {
                this.cm.getSign().set(key, null);
                System.err.println("Removed sign for nonexistant arena at location " + loc + ".");
                continue;
            }
            this.signs.add(new SignCreation(loc, arena));
        }
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)Main.getInstance(), new Runnable(){

            @Override
            public void run() {
                for (SignCreation sign : Signs.this.signs) {
                    sign.update();
                }
            }
        }, 0L, 20L);
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.SIGN && e.getClickedBlock().getType() != Material.SIGN_POST && e.getClickedBlock().getType() != Material.WALL_SIGN) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getClickedBlock();
        for (SignCreation sign : this.signs) {
            if (!sign.getLoc().equals((Object)b.getLocation())) continue;
            sign.getArena().addPlayer(p);
            this.mm.basicMessage(p, this.cm.getConfig().getString("Messages.events.Signs.joinarenamessage").replace("%arenaname%", sign.getArena().getArena()));
            break;
        }
    }
}

