package cz.m0bY_czE.rescmdsblacklist.listeners;

import com.bekvon.bukkit.residence.event.*;
import com.bekvon.bukkit.residence.protection.*;

import cz.m0bY_czE.rescmdsblacklist.ResCmdsBlacklist;

import java.util.*;
import org.bukkit.event.player.*;
import com.bekvon.bukkit.residence.*;
import org.bukkit.entity.*;
import org.bukkit.*;
import org.bukkit.event.*;

public class PlayerListener implements Listener
{
	public ResCmdsBlacklist plugin;
    public PlayerListener(final ResCmdsBlacklist plugin) {
    	this.plugin = plugin;
    }
    
    @EventHandler
    public <PlayerName> void ResidenceChangedEvent(final ResidenceChangedEvent event) {
        final ClaimedResidence res = event.getTo();
        if (res != null) {
            final List<String> executeCommands = plugin.getConfig().getStringList(String.valueOf(res.getName()) + ".execute-commands");
            for (int i = 0; i < executeCommands.size(); ++i) {
                final String executeCommand = executeCommands.get(i);
                final String players = event.getPlayer().getName();
                final String commandp = executeCommand.replace("%PLAYER%", players);
                if (!executeCommands.isEmpty()) {
                    Bukkit.dispatchCommand(Bukkit.getConsoleSender(), commandp);
                }
            }
        }
    }
    
    @EventHandler(priority = EventPriority.NORMAL)
    public void OnPlayerCommand(final PlayerCommandPreprocessEvent event) {
        final Player p = event.getPlayer();
        if (p.hasPermission("rescmdsblacklist.admin.bypass")) {
            return;
        }
        final Location loc = p.getLocation();
        final ClaimedResidence res = Residence.getInstance().getResidenceManager().getByLoc(loc);
        if (res != null) {
            final String message = event.getMessage();
            final List<String> disabledCommands = plugin.config().getStringList(String.valueOf(res.getName()) + ".blacklist-commands");
            final List<String> allowedCommands = plugin.getConfig().getStringList(String.valueOf(res.getName()) + ".allowed-commands");
            for (int i = 0; i < allowedCommands.size(); ++i) {
                final String allowedCommand = allowedCommands.get(i);
                if (!allowedCommand.isEmpty()) {
                    if (message.toLowerCase().startsWith(allowedCommand.toLowerCase())) {
                        return;
                    }
                }
            }
            for (int i = 0; i < disabledCommands.size(); ++i) {
                final String disabledCommand = disabledCommands.get(i);
                if (!disabledCommand.isEmpty()) {
                    if (disabledCommand.equals("*")) {
                        event.setCancelled(true);
                        event.getPlayer().sendMessage(ResCmdsBlacklist.messages.get("DISABLED_COMMANDS").replace("&", ""));
                        break;
                    }
                    if (message.toLowerCase().startsWith(disabledCommand.toLowerCase())) {
                        event.setCancelled(true);
                        event.getPlayer().sendMessage(ResCmdsBlacklist.messages.get("DISABLED_COMMANDS").replace("&", ""));
                    }
                }
            }
        }
    }
}