package cz.m0bY_czE.rescmdsblacklist;

import org.bukkit.plugin.java.*;
import java.io.*;
import cz.m0bY_czE.rescmdsblacklist.listeners.*;
import java.util.*;
import org.bukkit.plugin.*;
import org.bukkit.*;
import org.bukkit.event.*;
import org.bukkit.configuration.file.*;
import org.bukkit.command.*;

public class ResCmdsBlacklist extends JavaPlugin
{
    private static Plugin plugin;
    public static HashMap<String, String> messages;
    private ConfigManager configManager;
    
    static {
        ResCmdsBlacklist.messages = new HashMap<String, String>();
    }
    
    public ConfigManager getConfigManager() {
        return this.configManager;
    }
    
    public void onEnable() {
        configManager = new ConfigManager(this);
        configManager.loadConfigFiles("config.yml", "messages.yml");
        final File messagesFile = new File("plugins/" + this.getDescription().getName() + "/messages.yml");
        final YamlConfiguration yml = YamlConfiguration.loadConfiguration(messagesFile);
        for (final String id : yml.getKeys(false)) {
            ResCmdsBlacklist.messages.put(id, yml.getString(id));
        }
        plugin = this;
        final PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("Residence") != null) {
            pm.registerEvents(new PlayerListener(this), this);
            this.saveDefaultConfig();
            return;
        }
        consoleMessage(ChatColor.RED + "Plugin Residence not found. Disabling.");
        pm.disablePlugin(plugin);
    }
    
    public void onDisable() {
        plugin = null;
        unReg(new PlayerListener(this));
        unRegPlugin(this);
    }
    
    public static void consoleMessage(final String message) {
        final ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage(ChatColor.GREEN + "[" + plugin.getName() + "] " + message);
    }
    
    public static void unReg(final Listener... listeners) {
        for (final Listener l : listeners) {
            HandlerList.unregisterAll(l);
        }
    }
    
    public static void unRegPlugin(final Plugin p) {
        HandlerList.unregisterAll(p);
    }
    
    public FileConfiguration config() {
        return plugin.getConfig();
    }
    
    public boolean onCommand(final CommandSender sender, final Command cmd, final String label, final String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.WHITE + "ResCmdsBlacklist v" + this.getDescription().getVersion());
            sender.sendMessage(ChatColor.GRAY + "Commands:");
            sender.sendMessage(ChatColor.GRAY + "/rcb " + ChatColor.DARK_GRAY + "-" + ChatColor.WHITE + " Show commands");
            sender.sendMessage(ChatColor.GRAY + "/rcb reload" + ChatColor.DARK_GRAY + "-" + ChatColor.WHITE + " Reload config");
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("rescmdsblacklist.admin")) {
                this.reloadConfig();
                sender.sendMessage(ChatColor.GREEN + "[" + plugin.getName() + "]" + " Reloaded config.");
            }
            else {
                sender.sendMessage(ResCmdsBlacklist.messages.get("NO_PERMISSIONS").replace("&", ""));
            }
        }
        return false;
    }
}
