package cz.m0bY_czE.rescmdsblacklist;

import java.util.*;
import org.bukkit.configuration.*;
import java.io.*;
import org.bukkit.configuration.file.*;

public class ConfigManager
{
    private final ResCmdsBlacklist plugin;
    private final File configFolder;
    private final TreeMap<String, Configuration> configs;
    
    public ConfigManager(final ResCmdsBlacklist plugin) {
        this.configs = new TreeMap<String, Configuration>(String.CASE_INSENSITIVE_ORDER);
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
    }
    
    public void loadConfigFile(final String filename) {
        this.loadConfigFiles(filename);
    }
    
    public void loadConfigFiles(final String... filenames) {
        for (final String filename : filenames) {
            final File configFile = new File(this.configFolder, filename);
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                    final InputStream in = this.plugin.getResource(filename);
                    if (in != null) {
                        try {
                            final OutputStream out = new FileOutputStream(configFile);
                            final byte[] buf = new byte[1024];
                            int len;
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            out.close();
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    else {
                        this.plugin.getLogger().warning("Default configuration for " + filename + " missing");
                    }
                }
                final Configuration config = new Configuration(configFile);
                config.load();
                this.configs.put(filename, config);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            catch (InvalidConfigurationException e3) {
                e3.printStackTrace();
            }
        }
    }
    
    public void save(final String filename) {
        if (this.configs.containsKey(filename)) {
            try {
                this.configs.get(filename).save();
            }
            catch (Exception e) {
                this.printException(e, filename);
            }
        }
    }
    
    public void reload(final String filename) {
        if (this.configs.containsKey(filename)) {
            try {
                this.configs.get(filename).load();
            }
            catch (Exception e) {
                this.printException(e, filename);
            }
        }
    }
    
    public YamlConfiguration getConfig(final String filename) {
        if (this.configs.containsKey(filename)) {
            return this.configs.get(filename).getConfig();
        }
        return null;
    }
    
    private void printException(final Exception e, final String filename) {
        if (e instanceof IOException) {
            this.plugin.getLogger().severe("I/O exception while handling " + filename);
        }
        else if (e instanceof InvalidConfigurationException) {
            this.plugin.getLogger().severe("Invalid configuration in " + filename);
        }
        e.printStackTrace();
    }
    
    private static class Configuration
    {
        private final File configFile;
        private YamlConfiguration config;
        
        public Configuration(final File configFile) {
            this.configFile = configFile;
            this.config = new YamlConfiguration();
        }
        
        public YamlConfiguration getConfig() {
            return this.config;
        }
        
        public void load() throws IOException, InvalidConfigurationException {
            this.config.load(this.configFile);
        }
        
        public void save() throws IOException {
            this.config.save(this.configFile);
        }
    }
}
