/*
 * Decompiled with CFR 0.152.
 */
package Envyful.com.LegendCentral.Listeners;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class SpongeListener
implements Listener {
    static int i = 3;

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent e) {
        boolean isLava;
        World w = e.getBlock().getWorld();
        Block bFrom = e.getBlock();
        Block bTo = e.getToBlock();
        boolean bl = isLava = bFrom.getTypeId() == 10 || bFrom.getTypeId() == 11;
        if (isLava) {
            int ox = bTo.getX();
            int oy = bTo.getY();
            int oz = bTo.getZ();
            int cx = -i;
            while (cx <= i) {
                int cy = -i;
                while (cy <= i) {
                    int cz = -i;
                    while (cz <= i) {
                        Block sponge = w.getBlockAt(ox + cx, oy + cy, oz + cz);
                        if (sponge.getTypeId() == 19) {
                            e.setCancelled(true);
                            return;
                        }
                        ++cz;
                    }
                    ++cy;
                }
                ++cx;
            }
        }
    }

    @EventHandler
    public void SpongeBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        World w = b.getWorld();
        Location l = b.getLocation();
        if (b.getType() == Material.SPONGE) {
            e.setCancelled(true);
            b.setType(Material.AIR);
            w.dropItem(l, new ItemStack(Material.SPONGE, 1));
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Block b = e.getBlock();
        World w = b.getWorld();
        if (b.getType() == Material.SPONGE) {
            int ox = b.getX();
            int oy = b.getY();
            int oz = b.getZ();
            SpongeListener.clearSpongeWater(w, ox, oy, oz);
        }
    }

    public static void clearSpongeWater(World world, int ox, int oy, int oz) {
        int cx = -i;
        while (cx <= i) {
            int cy = -i;
            while (cy <= i) {
                int cz = -i;
                while (cz <= i) {
                    if (SpongeListener.isBlockWater(world, ox + cx, oy + cy, oz + cz)) {
                        world.getBlockAt(ox + cx, oy + cy, oz + cz).setTypeId(0);
                    }
                    ++cz;
                }
                ++cy;
            }
            ++cx;
        }
    }

    public static void addSpongeWater(World world, int ox, int oy, int oz) {
        int cz;
        int cx = ox - i - 1;
        int cy = oy - i - 1;
        while (cy <= oy + i + 1) {
            cz = oz - i - 1;
            while (cz <= oz + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx + 1, cy, cz);
                }
                ++cz;
            }
            ++cy;
        }
        cx = ox + i + 1;
        cy = oy - i - 1;
        while (cy <= oy + i + 1) {
            cz = oz - i - 1;
            while (cz <= oz + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx - 1, cy, cz);
                }
                ++cz;
            }
            ++cy;
        }
        cy = oy - i - 1;
        cx = ox - i - 1;
        while (cx <= ox + i + 1) {
            cz = oz - i - 1;
            while (cz <= oz + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx, cy + 1, cz);
                }
                ++cz;
            }
            ++cx;
        }
        cy = oy + i + 1;
        cx = ox - i - 1;
        while (cx <= ox + i + 1) {
            cz = oz - i - 1;
            while (cz <= oz + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx, cy - 1, cz);
                }
                ++cz;
            }
            ++cx;
        }
        cz = oz - i - 1;
        cx = ox - i - 1;
        while (cx <= ox + i + 1) {
            cy = oy - i - 1;
            while (cy <= oy + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx, cy, cz + 1);
                }
                ++cy;
            }
            ++cx;
        }
        cz = oz + i + 1;
        cx = ox - i - 1;
        while (cx <= ox + i + 1) {
            cy = oy - i - 1;
            while (cy <= oy + i + 1) {
                if (SpongeListener.isBlockWater(world, cx, cy, cz)) {
                    SpongeListener.setBlockToWater(world, cx, cy, cz - 1);
                }
                ++cy;
            }
            ++cx;
        }
    }

    public static boolean isBlockWater(World world, int ox, int oy, int oz) {
        Block block = world.getBlockAt(ox, oy, oz);
        int id = block.getTypeId();
        return id == 11 || id == 10;
    }

    public static void setBlockToWater(World world, int ox, int oy, int oz) {
        Block block = world.getBlockAt(ox, oy, oz);
        int id = block.getTypeId();
        if (id == 0) {
            block.setTypeId(11);
        }
    }
}

