package de.ghac.bpermtopex;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.WorldManager;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class BpermToPex extends JavaPlugin{
		
	
    @Override
    public void onDisable() {
        System.out.println("[" + this.getName() + "] Plugin deactivated!");
    }

    @Override
    public void onEnable() {
        System.out.println("[" + this.getName() + "] Plugin activated!");
        
        if(Bukkit.getServer().getPluginManager().getPlugin("bPermissions") == null){
            System.out.println("Could not find bPermissions, disabling.");
            Bukkit.getServer().getPluginManager().disablePlugin(this);
            return;
        }
        
        if(Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx") == null){
            System.out.println("Could not find PermissionsEx, disabling.");
            Bukkit.getServer().getPluginManager().disablePlugin(this);
            return;
        }
    }
    
    public void convert(String world){
    	
    	Set<Calculable> groups = WorldManager.getInstance().getWorld(world).getAll(CalculableType.GROUP);
    	System.out.println("Found " + groups.size() + " groups. Converting now.");

    	for(Calculable g : groups){
    		PermissionGroup pexgroup = PermissionsEx.getPermissionManager().getGroup(g.getNameLowerCase());
    		
    		if(!g.getValue("prefix").equalsIgnoreCase(""))
    			pexgroup.setPrefix(g.getValue("prefix"), null);
    		if(!g.getValue("suffix").equalsIgnoreCase(""))
    			pexgroup.setSuffix(g.getValue("suffix"), null);

    		List<PermissionGroup> parents = new ArrayList<PermissionGroup>();
    		parents.addAll(pexgroup.getParents());
    		for(Group g1 : g.getGroups()){
    			parents.add(PermissionsEx.getPermissionManager().getGroup(g1.getNameLowerCase()));
    		}
    		pexgroup.setParents(parents);
    		
			    		
    		Set<Permission> perms = g.getPermissions();
    		for(Permission perm : perms){
    			pexgroup.addPermission(perm.nameLowerCase());
    		}
    	}
    	System.out.println("Finished conversion of groups.");
    	
    	Set<Calculable> users = WorldManager.getInstance().getWorld(world).getAll(CalculableType.USER);
    	System.out.println("Found " + users.size() + " users. Converting now.");
    	
    	int lastpercent = -6;
    	int i = 0;
    	
    	for(Calculable u : users){
    		i++;
    		
    		if((int)i/users.size() > lastpercent+5){
    			lastpercent = (int)i/users.size();
    			System.out.println((double) (lastpercent/100) + "% - " + i + " / "+ users.size());
    		}
    		PermissionUser pexuser = PermissionsEx.getPermissionManager().getUser(UUID.fromString(u.getName()));
    		    		
    		if(!u.getValue("prefix").equalsIgnoreCase(""))
    			pexuser.setPrefix(u.getValue("prefix"), null);
    		if(!u.getValue("suffix").equalsIgnoreCase(""))
    			pexuser.setSuffix(u.getValue("suffix"), null);
    		
    		for(Group g : u.getGroups()){
    			pexuser.addGroup(g.getNameLowerCase());
    		}
    		
    		Set<Permission> perms = u.getPermissions();
    		for(Permission perm : perms){
    			pexuser.addPermission(perm.nameLowerCase());
    		}
    		
    	}
    	
    	System.out.println("Finished conversion of users.");
    	System.out.println("Done. Stop the server, remove this plugin and bPermissions.");

    }
    
	public boolean onCommand(CommandSender sender, Command cmd, String cmdLabel, String[] args){
		convert(args[0]);
	    return true;
	}
	   
    
}
