/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.realized.duels.util.Log;
import me.realized.duels.util.NumberUtil;
import org.bukkit.Bukkit;

public final class ReflectionUtil {
    private static final String PACKAGE_VERSION;
    private static final int MAJOR_VERSION;

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static Class<?> getClassUnsafe(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Method getMethodUnsafe(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getMethod(name, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Class<?> getNMSClass(String name, boolean logError) {
        try {
            return Class.forName("net.minecraft" + (ReflectionUtil.getMajorVersion() < 17 ? ".server." + PACKAGE_VERSION : "") + "." + name);
        }
        catch (ClassNotFoundException ex) {
            if (logError) {
                Log.error(ex.getMessage(), ex);
            }
            return null;
        }
    }

    public static Class<?> getNMSClass(String name) {
        return ReflectionUtil.getNMSClass(name, true);
    }

    public static Class<?> getCBClass(String path, boolean logError) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + PACKAGE_VERSION + "." + path);
        }
        catch (ClassNotFoundException ex) {
            if (logError) {
                Log.error(ex.getMessage(), ex);
            }
            return null;
        }
    }

    public static Class<?> getCBClass(String path) {
        return ReflectionUtil.getCBClass(path, true);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getMethod(name, parameters);
        }
        catch (NoSuchMethodException ex) {
            Log.error(ex.getMessage(), ex);
            return null;
        }
    }

    private static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(name, parameters);
        method.setAccessible(true);
        return method;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return ReflectionUtil.findDeclaredMethod(clazz, name, parameters);
        }
        catch (NoSuchMethodException ex) {
            Log.error(ex.getMessage(), ex);
            return null;
        }
    }

    public static Method getDeclaredMethodUnsafe(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return ReflectionUtil.findDeclaredMethod(clazz, name, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException ex) {
            Log.error(ex.getMessage(), ex);
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            Log.error(ex.getMessage(), ex);
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameters) {
        try {
            return clazz.getConstructor(parameters);
        }
        catch (NoSuchMethodException ex) {
            Log.error(ex.getMessage(), ex);
            return null;
        }
    }

    private ReflectionUtil() {
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        PACKAGE_VERSION = packageName.substring(packageName.lastIndexOf(46) + 1);
        MAJOR_VERSION = NumberUtil.parseInt(PACKAGE_VERSION.split("_")[1]).orElse(0);
    }
}

