/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.util.metadata;

import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class MetadataUtil {
    private MetadataUtil() {
    }

    public static Object get(Plugin plugin, Entity entity, String key) {
        return entity.getMetadata(key).stream().filter(value -> value.getOwningPlugin().equals(plugin)).findFirst().map(MetadataValue::value).orElse(null);
    }

    public static void put(Plugin plugin, Entity entity, String key, Object data) {
        entity.setMetadata(key, (MetadataValue)new FixedMetadataValue(plugin, data));
    }

    public static void remove(Plugin plugin, Entity entity, String key) {
        entity.removeMetadata(key, plugin);
    }

    public static Object removeAndGet(Plugin plugin, Entity entity, String key) {
        Object value = MetadataUtil.get(plugin, entity, key);
        MetadataUtil.remove(plugin, entity, key);
        return value;
    }
}

