/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.teleport;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.hook.hooks.EssentialsHook;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.metadata.MetadataUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class Teleport
implements Loadable,
Listener {
    public static final String METADATA_KEY = "Duels-Teleport";
    private final DuelsPlugin plugin;
    private EssentialsHook essentials;

    public Teleport(DuelsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handleLoad() {
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        this.plugin.doSyncAfter(() -> this.plugin.registerListener(this), 1L);
    }

    @Override
    public void handleUnload() {
    }

    public void tryTeleport(Player player, Location location) {
        if (location == null || location.getWorld() == null) {
            Log.warn(this, "Could not teleport " + player.getName() + "! Location is null");
            return;
        }
        if (this.essentials != null) {
            this.essentials.setBackLocation(player, location);
        }
        MetadataUtil.put(this.plugin, (Entity)player, METADATA_KEY, location.clone());
        if (!player.teleport(location)) {
            Log.warn(this, "Could not teleport " + player.getName() + "! Player is dead or is vehicle");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Object value = MetadataUtil.removeAndGet(this.plugin, (Entity)player, METADATA_KEY);
        if (!event.isCancelled() || value == null) {
            return;
        }
        event.setCancelled(false);
        event.setTo((Location)value);
    }
}

