/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.spectate;

import java.util.Objects;
import java.util.UUID;
import me.realized.duels.api.spectate.Spectator;
import me.realized.duels.arena.ArenaImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class SpectatorImpl
implements Spectator {
    private final UUID uuid;
    private final UUID targetUuid;
    private final String targetName;
    private final ArenaImpl arena;

    SpectatorImpl(Player owner, Player target, ArenaImpl arena) {
        this.uuid = owner.getUniqueId();
        this.targetUuid = target.getUniqueId();
        this.targetName = target.getName();
        this.arena = arena;
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    @Nullable
    public Player getTarget() {
        return Bukkit.getPlayer((UUID)this.targetUuid);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SpectatorImpl spectator = (SpectatorImpl)other;
        return Objects.equals(this.uuid, spectator.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public ArenaImpl getArena() {
        return this.arena;
    }
}

