/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.setting;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.gui.settings.SettingsGui;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.setting.CachedInfo;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Settings {
    private final DuelsPlugin plugin;
    private final SettingsGui gui;
    private UUID target;
    private KitImpl kit;
    private ArenaImpl arena;
    private int bet;
    private boolean itemBetting;
    private boolean ownInventory;
    private Map<UUID, CachedInfo> cache = new HashMap<UUID, CachedInfo>();

    public Settings(DuelsPlugin plugin, Player player) {
        this.plugin = plugin;
        this.gui = player != null ? plugin.getGuiListener().addGui(player, new SettingsGui(plugin)) : null;
        this.ownInventory = !plugin.getConfiguration().isKitSelectingEnabled();
    }

    public Settings(DuelsPlugin plugin) {
        this(plugin, null);
    }

    public void reset() {
        this.target = null;
        this.kit = null;
        this.arena = null;
        this.bet = 0;
        this.itemBetting = false;
        this.ownInventory = !this.plugin.getConfiguration().isKitSelectingEnabled();
    }

    public void setTarget(Player target) {
        if (this.target != null && !this.target.equals(target.getUniqueId())) {
            this.reset();
        }
        this.target = target.getUniqueId();
    }

    public void updateGui(Player player) {
        if (this.gui != null) {
            this.gui.update(player);
        }
    }

    public void openGui(Player player) {
        this.gui.open(player);
    }

    public void setBaseLoc(Player player) {
        this.cache.computeIfAbsent(player.getUniqueId(), result -> new CachedInfo()).setLocation(player.getLocation().clone());
    }

    public Location getBaseLoc(Player player) {
        CachedInfo info = this.cache.get(player.getUniqueId());
        if (info == null) {
            return null;
        }
        return info.getLocation();
    }

    public void setDuelzone(Player player, String duelzone) {
        this.cache.computeIfAbsent(player.getUniqueId(), result -> new CachedInfo()).setDuelzone(duelzone);
    }

    public String getDuelzone(Player player) {
        CachedInfo info = this.cache.get(player.getUniqueId());
        if (info == null) {
            return null;
        }
        return info.getDuelzone();
    }

    public void setKit(KitImpl kit) {
        this.kit = kit;
        this.ownInventory = false;
    }

    public void setOwnInventory(boolean ownInventory) {
        this.ownInventory = ownInventory;
        if (ownInventory) {
            this.kit = null;
        }
    }

    public Settings lightCopy() {
        Settings copy = new Settings(this.plugin);
        copy.target = this.target;
        copy.kit = this.kit;
        copy.arena = this.arena;
        copy.bet = this.bet;
        copy.itemBetting = this.itemBetting;
        copy.ownInventory = this.ownInventory;
        copy.cache = new HashMap<UUID, CachedInfo>(this.cache);
        return copy;
    }

    public UUID getTarget() {
        return this.target;
    }

    public KitImpl getKit() {
        return this.kit;
    }

    public ArenaImpl getArena() {
        return this.arena;
    }

    public void setArena(ArenaImpl arena) {
        this.arena = arena;
    }

    public int getBet() {
        return this.bet;
    }

    public void setBet(int bet) {
        this.bet = bet;
    }

    public boolean isItemBetting() {
        return this.itemBetting;
    }

    public void setItemBetting(boolean itemBetting) {
        this.itemBetting = itemBetting;
    }

    public boolean isOwnInventory() {
        return this.ownInventory;
    }

    public Map<UUID, CachedInfo> getCache() {
        return this.cache;
    }
}

