/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.request;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.request.RequestSendEvent;
import me.realized.duels.config.Config;
import me.realized.duels.config.Lang;
import me.realized.duels.request.RequestImpl;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.TextBuilder;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class RequestManager
implements Loadable,
Listener {
    private final Config config;
    private final Lang lang;
    private final Map<UUID, Map<UUID, RequestImpl>> requests = new HashMap<UUID, Map<UUID, RequestImpl>>();

    public RequestManager(DuelsPlugin plugin) {
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void handleLoad() {
    }

    @Override
    public void handleUnload() {
        this.requests.clear();
    }

    private Map<UUID, RequestImpl> get(Player player, boolean create) {
        Map<UUID, RequestImpl> cached = this.requests.get(player.getUniqueId());
        if (cached == null && create) {
            cached = new HashMap<UUID, RequestImpl>();
            this.requests.put(player.getUniqueId(), cached);
            return cached;
        }
        return cached;
    }

    public void send(Player sender, Player target, Settings settings) {
        RequestImpl request = new RequestImpl(sender, target, settings);
        RequestSendEvent event = new RequestSendEvent(sender, target, request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.get(sender, true).put(target.getUniqueId(), request);
        String kit = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.not-selected");
        String ownInventory = settings.isOwnInventory() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        int betAmount = settings.getBet();
        String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        this.lang.sendMessage((CommandSender)sender, "COMMAND.duel.request.send.sender", "name", target.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena, "bet_amount", betAmount, "item_betting", itemBetting);
        this.lang.sendMessage((CommandSender)target, "COMMAND.duel.request.send.receiver", "name", sender.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena, "bet_amount", betAmount, "item_betting", itemBetting);
        String path = "COMMAND.duel.request.send.clickable-text.";
        TextBuilder.of(this.lang.getMessage("COMMAND.duel.request.send.clickable-text.info.text"), null, null, HoverEvent.Action.SHOW_TEXT, this.lang.getMessage("COMMAND.duel.request.send.clickable-text.info.hover-text")).add(this.lang.getMessage("COMMAND.duel.request.send.clickable-text.accept.text"), ClickEvent.Action.RUN_COMMAND, "/duel accept " + sender.getName(), HoverEvent.Action.SHOW_TEXT, this.lang.getMessage("COMMAND.duel.request.send.clickable-text.accept.hover-text")).add(this.lang.getMessage("COMMAND.duel.request.send.clickable-text.deny.text"), ClickEvent.Action.RUN_COMMAND, "/duel deny " + sender.getName(), HoverEvent.Action.SHOW_TEXT, this.lang.getMessage("COMMAND.duel.request.send.clickable-text.deny.hover-text")).send(target);
        TextBuilder.of(this.lang.getMessage("COMMAND.duel.request.send.clickable-text.extra.text"), null, null, HoverEvent.Action.SHOW_TEXT, this.lang.getMessage("COMMAND.duel.request.send.clickable-text.extra.hover-text")).send(target);
    }

    public RequestImpl get(Player sender, Player target) {
        Map<UUID, RequestImpl> cached = this.get(sender, false);
        if (cached == null) {
            return null;
        }
        RequestImpl request = cached.get(target.getUniqueId());
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.getCreation() >= (long)this.config.getExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return request;
    }

    public boolean has(Player sender, Player target) {
        return this.get(sender, target) != null;
    }

    public RequestImpl remove(Player sender, Player target) {
        Map<UUID, RequestImpl> cached = this.get(sender, false);
        if (cached == null) {
            return null;
        }
        RequestImpl request = cached.remove(target.getUniqueId());
        if (request == null) {
            return null;
        }
        if (System.currentTimeMillis() - request.getCreation() >= (long)this.config.getExpiration() * 1000L) {
            cached.remove(target.getUniqueId());
            return null;
        }
        return request;
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.requests.remove(event.getPlayer().getUniqueId());
    }
}

