/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.queue.sign;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.queue.sign.QueueSignCreateEvent;
import me.realized.duels.api.event.queue.sign.QueueSignRemoveEvent;
import me.realized.duels.api.queue.sign.QueueSign;
import me.realized.duels.api.queue.sign.QueueSignManager;
import me.realized.duels.config.Lang;
import me.realized.duels.data.QueueSignData;
import me.realized.duels.queue.Queue;
import me.realized.duels.queue.QueueManager;
import me.realized.duels.queue.sign.QueueSignImpl;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.io.FileUtil;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueSignManagerImpl
implements Loadable,
QueueSignManager,
Listener {
    private static final String FILE_NAME = "signs.json";
    private static final String SIGNS_LOADED = "Loaded %s queue sign(s).";
    private final DuelsPlugin plugin;
    private final Lang lang;
    private final QueueManager queueManager;
    private final File file;
    private final Map<Location, QueueSignImpl> signs = new HashMap<Location, QueueSignImpl>();
    private int updateTask;

    public QueueSignManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLang();
        this.queueManager = plugin.getQueueManager();
        this.file = new File(plugin.getDataFolder(), FILE_NAME);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void handleLoad() throws IOException {
        if (FileUtil.checkNonEmpty(this.file, true)) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8);){
                List<QueueSignData> data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<List<QueueSignData>>(){});
                if (data != null) {
                    data.forEach(queueSignData -> {
                        QueueSignImpl queueSign = queueSignData.toQueueSign(this.plugin);
                        if (queueSign != null) {
                            this.signs.put(queueSign.getLocation(), queueSign);
                        }
                    });
                }
            }
        }
        Log.info(this, String.format(SIGNS_LOADED, this.signs.size()));
        this.updateTask = this.plugin.doSyncRepeat(() -> this.signs.entrySet().removeIf(entry -> {
            ((QueueSignImpl)entry.getValue()).update();
            return ((QueueSignImpl)entry.getValue()).getQueue().isRemoved();
        }), 20L, 20L).getTaskId();
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.updateTask);
        this.signs.clear();
    }

    private void saveQueueSigns() {
        ArrayList<QueueSignData> data = new ArrayList<QueueSignData>();
        for (QueueSignImpl sign : this.signs.values()) {
            if (sign.getQueue().isRemoved()) continue;
            data.add(new QueueSignData(sign));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            Log.error(this, ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public QueueSignImpl get(@NotNull Sign sign) {
        Objects.requireNonNull(sign, "sign");
        return this.get(sign.getLocation());
    }

    public QueueSignImpl get(Location location) {
        return this.signs.get(location);
    }

    public boolean create(Player creator, Location location, Queue queue) {
        if (this.get(location) != null) {
            return false;
        }
        String kitName = queue.getKit() != null ? queue.getKit().getName() : this.lang.getMessage("GENERAL.none");
        QueueSignImpl created = new QueueSignImpl(location, this.lang.getMessage("SIGN.format", "kit", kitName, "bet_amount", queue.getBet()), queue);
        this.signs.put(location, created);
        this.signs.values().stream().filter(sign -> sign.equals(created)).forEach(QueueSignImpl::update);
        this.saveQueueSigns();
        QueueSignCreateEvent event = new QueueSignCreateEvent(creator, created);
        Bukkit.getPluginManager().callEvent((Event)event);
        return true;
    }

    public QueueSignImpl remove(Player source, Location location) {
        QueueSignImpl queueSign = this.signs.remove(location);
        if (queueSign == null) {
            return null;
        }
        queueSign.setRemoved(true);
        this.saveQueueSigns();
        QueueSignRemoveEvent event = new QueueSignRemoveEvent(source, queueSign);
        Bukkit.getPluginManager().callEvent((Event)event);
        return queueSign;
    }

    public Collection<QueueSignImpl> getSigns() {
        return this.signs.values();
    }

    @Override
    @NotNull
    public List<QueueSign> getQueueSigns() {
        return Lists.newArrayList(this.getSigns());
    }

    @EventHandler
    public void on(PlayerInteractEvent event) {
        Block block;
        if (!event.hasBlock() || !((block = event.getClickedBlock()).getState() instanceof Sign)) {
            return;
        }
        Player player = event.getPlayer();
        QueueSignImpl sign = this.get(block.getLocation());
        if (sign == null || !this.queueManager.queue(player, sign.getQueue())) {
            return;
        }
        this.signs.values().stream().filter(queueSign -> queueSign.equals(sign)).forEach(QueueSignImpl::update);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!(block.getState() instanceof Sign) || this.get(block.getLocation()) == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("duels.admin")) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.admin");
            return;
        }
        this.lang.sendMessage((CommandSender)player, "ERROR.sign.cancel-break", new Object[0]);
        event.setCancelled(true);
    }
}

