/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.queue;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.queue.QueueCreateEvent;
import me.realized.duels.api.event.queue.QueueJoinEvent;
import me.realized.duels.api.event.queue.QueueLeaveEvent;
import me.realized.duels.api.event.queue.QueueRemoveEvent;
import me.realized.duels.api.kit.Kit;
import me.realized.duels.api.queue.DQueue;
import me.realized.duels.api.queue.DQueueManager;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.config.Config;
import me.realized.duels.config.Lang;
import me.realized.duels.data.QueueData;
import me.realized.duels.data.UserData;
import me.realized.duels.data.UserManagerImpl;
import me.realized.duels.duel.DuelManager;
import me.realized.duels.hook.hooks.CombatTagPlusHook;
import me.realized.duels.hook.hooks.PvPManagerHook;
import me.realized.duels.hook.hooks.VaultHook;
import me.realized.duels.hook.hooks.worldguard.WorldGuardHook;
import me.realized.duels.kit.KitManagerImpl;
import me.realized.duels.queue.Queue;
import me.realized.duels.queue.QueueEntry;
import me.realized.duels.setting.Settings;
import me.realized.duels.spectate.SpectateManagerImpl;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.NumberUtil;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.MultiPageGui;
import me.realized.duels.util.inventory.InventoryUtil;
import me.realized.duels.util.inventory.ItemBuilder;
import me.realized.duels.util.io.FileUtil;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueManager
implements Loadable,
DQueueManager,
Listener {
    private static final String FILE_NAME = "queues.json";
    private static final String QUEUES_LOADED = "Loaded %s queue(s).";
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final UserManagerImpl userManager;
    private final KitManagerImpl kitManager;
    private final ArenaManagerImpl arenaManager;
    private final SpectateManagerImpl spectateManager;
    private final DuelManager duelManager;
    private final File file;
    private final List<Queue> queues = new ArrayList<Queue>();
    private CombatTagPlusHook combatTagPlus;
    private PvPManagerHook pvpManager;
    private WorldGuardHook worldGuard;
    private VaultHook vault;
    private int queueTask;
    private MultiPageGui<DuelsPlugin> gui;

    public QueueManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userManager = plugin.getUserManager();
        this.kitManager = plugin.getKitManager();
        this.arenaManager = plugin.getArenaManager();
        this.spectateManager = plugin.getSpectateManager();
        this.duelManager = plugin.getDuelManager();
        this.file = new File(plugin.getDataFolder(), FILE_NAME);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean canFight(Kit kit, UserData first, UserData second) {
        if (kit == null || !this.config.isRatingEnabled()) {
            return true;
        }
        if (first != null && second != null) {
            int firstRating = first.getRating(kit);
            int secondRating = second.getRating(kit);
            int kFactor = this.config.getKFactor();
            return NumberUtil.getChange(kFactor, firstRating, secondRating) != 0 && NumberUtil.getChange(kFactor, secondRating, firstRating) != 0;
        }
        return false;
    }

    @Override
    public void handleLoad() throws IOException {
        this.gui = new MultiPageGui<DuelsPlugin>(this.plugin, this.lang.getMessage("GUI.queues.title"), this.config.getQueuesRows(), this.queues);
        this.gui.setSpaceFiller(Items.from(this.config.getQueuesFillerType(), this.config.getQueuesFillerData()));
        this.gui.setPrevButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.previous-page.name")).build());
        this.gui.setNextButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.next-page.name")).build());
        this.gui.setEmptyIndicator(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.queues.buttons.empty.name")).build());
        this.plugin.getGuiListener().addGui(this.gui);
        if (FileUtil.checkNonEmpty(this.file, true)) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8);){
                List<QueueData> data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<List<QueueData>>(){});
                if (data != null) {
                    data.forEach(queueData -> {
                        Queue queue = queueData.toQueue(this.plugin);
                        if (queue != null && !this.queues.contains(queue)) {
                            this.queues.add(queue);
                        }
                    });
                }
            }
        }
        Log.info(this, String.format(QUEUES_LOADED, this.queues.size()));
        this.gui.calculatePages();
        this.combatTagPlus = this.plugin.getHookManager().getHook(CombatTagPlusHook.class);
        this.pvpManager = this.plugin.getHookManager().getHook(PvPManagerHook.class);
        this.worldGuard = this.plugin.getHookManager().getHook(WorldGuardHook.class);
        this.vault = this.plugin.getHookManager().getHook(VaultHook.class);
        this.queueTask = this.plugin.doSyncRepeat(() -> {
            boolean update = false;
            for (Queue queue : this.queues) {
                HashSet<QueueEntry> remove = new HashSet<QueueEntry>();
                block1: for (QueueEntry current : queue.getPlayers()) {
                    if (remove.contains(current)) continue;
                    Player player = current.getPlayer();
                    for (QueueEntry opponent : queue.getPlayers()) {
                        Player other = opponent.getPlayer();
                        if (current.equals(opponent) || remove.contains(opponent) || !this.canFight(queue.getKit(), this.userManager.get(player), this.userManager.get(other))) continue;
                        remove.add(current);
                        remove.add(opponent);
                        Settings setting = new Settings(this.plugin);
                        if (queue.getKit() != null) {
                            setting.setKit(this.kitManager.get(queue.getKit().getName()));
                        } else {
                            setting.setOwnInventory(true);
                        }
                        setting.setBet(queue.getBet());
                        setting.getCache().put(player.getUniqueId(), current.getInfo());
                        setting.getCache().put(other.getUniqueId(), opponent.getInfo());
                        String kit = queue.getKit() != null ? queue.getKit().getName() : this.lang.getMessage("GENERAL.none");
                        this.lang.sendMessage((CommandSender)player, "QUEUE.found-opponent", "name", other.getName(), "kit", kit, "bet_amount", queue.getBet());
                        this.lang.sendMessage((CommandSender)other, "QUEUE.found-opponent", "name", player.getName(), "kit", kit, "bet_amount", queue.getBet());
                        this.duelManager.startMatch(player, other, setting, null, queue);
                        continue block1;
                    }
                }
                if (!queue.removeAll(remove) || update) continue;
                update = true;
            }
            if (update) {
                this.gui.calculatePages();
            }
        }, 20L, 40L).getTaskId();
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.queueTask);
        if (this.gui != null) {
            this.plugin.getGuiListener().removeGui(this.gui);
        }
        this.queues.clear();
    }

    private void saveQueues() {
        ArrayList<QueueData> data = new ArrayList<QueueData>();
        for (Queue queue : this.queues) {
            data.add(new QueueData(queue));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            Log.error(this, ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public Queue get(@Nullable Kit kit, int bet) {
        return this.queues.stream().filter(queue -> Objects.equals(kit, queue.getKit()) && queue.getBet() == bet).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Queue get(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.queues.stream().filter(queue -> queue.isInQueue(player)).findFirst().orElse(null);
    }

    @Nullable
    public Queue randomQueue() {
        return !this.queues.isEmpty() ? this.queues.get(ThreadLocalRandom.current().nextInt(this.queues.size())) : null;
    }

    @Override
    @Nullable
    public Queue create(@Nullable CommandSender source, @Nullable Kit kit, int bet) {
        Queue queue = new Queue(this.plugin, kit, bet);
        if (this.queues.contains(queue)) {
            return null;
        }
        this.queues.add(queue);
        this.saveQueues();
        QueueCreateEvent event = new QueueCreateEvent(source, queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return queue;
    }

    @Override
    @Nullable
    public Queue create(@Nullable Kit kit, int bet) {
        return this.create(null, kit, bet);
    }

    @Override
    @Nullable
    public Queue remove(@Nullable CommandSender source, @Nullable Kit kit, int bet) {
        return this.remove(source, this.get(kit, bet));
    }

    @Override
    @Nullable
    public Queue remove(@Nullable Kit kit, int bet) {
        return this.remove(null, kit, bet);
    }

    @Override
    @NotNull
    public List<DQueue> getQueues() {
        return Collections.unmodifiableList(this.queues);
    }

    @Override
    public boolean isInQueue(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.queues.stream().anyMatch(queue -> queue.isInQueue(player));
    }

    @Override
    public boolean addToQueue(@NotNull Player player, @NotNull DQueue queue) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(queue, "queue");
        return this.queue(player, (Queue)queue);
    }

    @Override
    @Nullable
    public DQueue removeFromQueue(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.remove(player);
    }

    public Queue remove(CommandSender source, Queue queue) {
        if (queue == null || !this.queues.remove(queue)) {
            return null;
        }
        this.saveQueues();
        queue.getPlayers().forEach(entry -> this.lang.sendMessage((CommandSender)entry.getPlayer(), "QUEUE.remove", new Object[0]));
        queue.getPlayers().clear();
        queue.setRemoved(true);
        QueueRemoveEvent event = new QueueRemoveEvent(source, queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return queue;
    }

    public boolean queue(Player player, Queue queue) {
        Queue found = this.get(player);
        if (found != null) {
            if (found.equals(queue)) {
                queue.removePlayer(player);
                this.lang.sendMessage((CommandSender)player, "QUEUE.remove", new Object[0]);
                return false;
            }
            this.lang.sendMessage((CommandSender)player, "ERROR.queue.already-in", new Object[0]);
            return false;
        }
        if (this.spectateManager.isSpectating(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.spectate.already-spectating.sender", new Object[0]);
            return false;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.already-in-match.sender", new Object[0]);
            return false;
        }
        if (this.config.isRequiresClearedInventory() && InventoryUtil.hasItem(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.inventory-not-empty", new Object[0]);
            return false;
        }
        if (this.config.isPreventCreativeMode() && player.getGameMode() == GameMode.CREATIVE) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.in-creative-mode", new Object[0]);
            return false;
        }
        if (this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.is-tagged", new Object[0]);
            return false;
        }
        String duelzone = null;
        if (this.worldGuard != null && this.config.isDuelzoneEnabled() && (duelzone = this.worldGuard.findDuelZone(player)) == null) {
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.not-in-duelzone", "regions", this.config.getDuelzones());
            return false;
        }
        if (queue.getBet() > 0 && this.vault != null && !this.vault.has(queue.getBet(), player)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.queue.not-enough-money", "bet_amount", queue.getBet());
            return false;
        }
        QueueJoinEvent event = new QueueJoinEvent(player, (DQueue)queue);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        queue.addPlayer(new QueueEntry(player, player.getLocation().clone(), duelzone));
        String kit = queue.getKit() != null ? queue.getKit().getName() : this.lang.getMessage("GENERAL.none");
        this.lang.sendMessage((CommandSender)player, "QUEUE.add", "kit", kit, "bet_amount", queue.getBet());
        return true;
    }

    public Queue remove(Player player) {
        for (Queue queue : this.queues) {
            if (!queue.removePlayer(player)) continue;
            QueueLeaveEvent event = new QueueLeaveEvent(player, (DQueue)queue);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.lang.sendMessage((CommandSender)player, "QUEUE.remove", new Object[0]);
            return queue;
        }
        return null;
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.remove(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void on(PlayerCommandPreprocessEvent event) {
        String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
        if (!this.isInQueue(event.getPlayer()) || !this.config.getQueueBlacklistedCommands().contains(command)) {
            return;
        }
        event.setCancelled(true);
        this.lang.sendMessage((CommandSender)event.getPlayer(), "QUEUE.prevent.command", "command", event.getMessage());
    }

    public MultiPageGui<DuelsPlugin> getGui() {
        return this.gui;
    }
}

