/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.player;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.config.Config;
import me.realized.duels.data.LocationData;
import me.realized.duels.data.PlayerData;
import me.realized.duels.hook.hooks.EssentialsHook;
import me.realized.duels.player.PlayerInfo;
import me.realized.duels.teleport.Teleport;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.PlayerUtil;
import me.realized.duels.util.io.FileUtil;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PlayerInfoManager
implements Loadable {
    private static final String CACHE_FILE_NAME = "player-cache.json";
    private static final String LOBBY_FILE_NAME = "lobby.json";
    private static final String ERROR_LOBBY_LOAD = "Could not load lobby location!";
    private static final String ERROR_LOBBY_SAVE = "Could not save lobby location!";
    private static final String ERROR_LOBBY_DEFAULT = "Lobby location was not set, using %s's spawn location as default. Use the command /duels setlobby in-game to set the lobby location.";
    private final DuelsPlugin plugin;
    private final Config config;
    private final File cacheFile;
    private final File lobbyFile;
    private final Map<UUID, PlayerInfo> cache = new HashMap<UUID, PlayerInfo>();
    private Teleport teleport;
    private EssentialsHook essentials;
    private Location lobby;

    public PlayerInfoManager(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.cacheFile = new File(plugin.getDataFolder(), CACHE_FILE_NAME);
        this.lobbyFile = new File(plugin.getDataFolder(), LOBBY_FILE_NAME);
        plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)new PlayerInfoListener(), (Plugin)plugin), 1L);
    }

    @Override
    public void handleLoad() throws IOException {
        Throwable throwable;
        InputStreamReader reader;
        this.teleport = this.plugin.getTeleport();
        this.essentials = this.plugin.getHookManager().getHook(EssentialsHook.class);
        if (FileUtil.checkNonEmpty(this.cacheFile, false)) {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), Charsets.UTF_8);
            throwable = null;
            try {
                Map data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<HashMap<UUID, PlayerData>>(){});
                if (data != null) {
                    for (Map.Entry entry : data.entrySet()) {
                        this.cache.put((UUID)entry.getKey(), ((PlayerData)entry.getValue()).toPlayerInfo());
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            this.cacheFile.delete();
        }
        if (FileUtil.checkNonEmpty(this.lobbyFile, false)) {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(this.lobbyFile), Charsets.UTF_8);
                throwable = null;
                try {
                    this.lobby = JsonUtil.getObjectMapper().readValue((Reader)reader, LocationData.class).toLocation();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                Log.error(this, ERROR_LOBBY_LOAD, ex);
            }
        }
        if (this.lobby == null || this.lobby.getWorld() == null) {
            World world = (World)Bukkit.getWorlds().get(0);
            this.lobby = world.getSpawnLocation();
            Log.warn(this, String.format(ERROR_LOBBY_DEFAULT, world.getName()));
        }
    }

    @Override
    public void handleUnload() throws IOException {
        Bukkit.getOnlinePlayers().stream().filter(Entity::isDead).forEach(player -> {
            PlayerInfo info = this.remove((Player)player);
            if (info != null) {
                player.spigot().respawn();
                this.teleport.tryTeleport((Player)player, info.getLocation());
                PlayerUtil.reset(player);
                info.restore((Player)player);
            }
        });
        if (this.cache.isEmpty()) {
            return;
        }
        HashMap<UUID, PlayerData> data = new HashMap<UUID, PlayerData>();
        for (Map.Entry<UUID, PlayerInfo> entry : this.cache.entrySet()) {
            data.put(entry.getKey(), PlayerData.fromPlayerInfo(entry.getValue()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cacheFile), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        this.cache.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setLobby(Player player) {
        Location lobby = player.getLocation().clone();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.lobbyFile), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, (Object)LocationData.fromLocation(lobby));
            ((Writer)writer).flush();
            this.lobby = lobby;
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Log.error(this, ERROR_LOBBY_SAVE, ex);
            return false;
        }
    }

    public PlayerInfo get(Player player) {
        return this.cache.get(player.getUniqueId());
    }

    public void create(Player player) {
        PlayerInfo info = new PlayerInfo(player);
        if (!this.config.isTeleportToLastLocation()) {
            info.setLocation(this.lobby.clone());
        }
        this.cache.put(player.getUniqueId(), info);
    }

    public PlayerInfo remove(Player player) {
        return this.cache.remove(player.getUniqueId());
    }

    public Location getLobby() {
        return this.lobby;
    }

    private class PlayerInfoListener
    implements Listener {
        private PlayerInfoListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (player.isDead()) {
                return;
            }
            PlayerInfo info = PlayerInfoManager.this.remove(player);
            if (info == null) {
                return;
            }
            PlayerInfoManager.this.teleport.tryTeleport(player, info.getLocation());
            info.restore(player);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void on(PlayerRespawnEvent event) {
            Player player = event.getPlayer();
            PlayerInfo info = PlayerInfoManager.this.get(player);
            if (info == null) {
                return;
            }
            event.setRespawnLocation(info.getLocation());
            if (PlayerInfoManager.this.essentials != null) {
                PlayerInfoManager.this.essentials.setBackLocation(player, event.getRespawnLocation());
            }
            PlayerInfoManager.this.plugin.doSyncAfter(() -> {
                if (!player.isOnline()) {
                    return;
                }
                PlayerInfoManager.this.remove(player);
                info.restore(player);
            }, 1L);
        }
    }
}

