/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.listeners;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.match.MatchEndEvent;
import me.realized.duels.api.event.match.MatchStartEvent;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.arena.MatchImpl;
import me.realized.duels.config.Config;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.PlayerUtil;
import me.realized.duels.util.compat.CompatUtil;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.metadata.MetadataUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitOptionsListener
implements Listener {
    private static final String METADATA_KEY = "Duels-MaxNoDamageTicks";
    private final DuelsPlugin plugin;
    private final Config config;
    private final ArenaManagerImpl arenaManager;

    public KitOptionsListener(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)(CompatUtil.isPre1_14() ? new ComboPre1_14Listener() : new ComboPost1_14Listener()), (Plugin)plugin);
    }

    private boolean isEnabled(ArenaImpl arena, KitImpl.Characteristic characteristic) {
        MatchImpl match = arena.getMatch();
        return match != null && match.getKit() != null && match.getKit().hasCharacteristic(characteristic);
    }

    @EventHandler
    public void on(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.SUMO)) {
            return;
        }
        event.setDamage(0.0);
    }

    @EventHandler
    public void on(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        ArenaImpl arena = this.arenaManager.get(player);
        if (player.isDead() || arena == null || !this.isEnabled(arena, KitImpl.Characteristic.SUMO) || arena.isEndGame()) {
            return;
        }
        Block block = event.getFrom().getBlock();
        if (!block.getType().name().contains("WATER") && !block.getType().name().contains("LAVA")) {
            return;
        }
        player.setHealth(0.0);
    }

    @EventHandler
    public void on(PlayerInteractEvent event) {
        ItemStack bowl;
        if (!event.hasItem() || !event.getAction().name().contains("RIGHT")) {
            return;
        }
        Player player = event.getPlayer();
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.SOUP)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Items.MUSHROOM_SOUP) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
        if (this.config.isSoupCancelIfAlreadyFull() && player.getHealth() == PlayerUtil.getMaxHealth(player)) {
            return;
        }
        ItemStack itemStack = bowl = this.config.isSoupRemoveEmptyBowl() ? null : new ItemStack(Material.BOWL);
        if (CompatUtil.isPre1_10()) {
            player.getInventory().setItem(player.getInventory().getHeldItemSlot(), bowl);
        } else if (event.getHand() == EquipmentSlot.OFF_HAND) {
            player.getInventory().setItemInOffHand(bowl);
        } else {
            player.getInventory().setItemInMainHand(bowl);
        }
        player.getInventory().setItem(player.getInventory().getHeldItemSlot(), this.config.isSoupRemoveEmptyBowl() ? null : new ItemStack(Material.BOWL));
        double regen = this.config.getSoupHeartsToRegen() * 2.0;
        double oldHealth = player.getHealth();
        double maxHealth = PlayerUtil.getMaxHealth(player);
        player.setHealth(Math.min(oldHealth + regen, maxHealth));
    }

    @EventHandler(ignoreCancelled=true)
    public void on(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED && event.getRegainReason() != EntityRegainHealthEvent.RegainReason.REGEN) {
            return;
        }
        Player player = (Player)event.getEntity();
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.isEnabled(arena, KitImpl.Characteristic.UHC)) {
            return;
        }
        event.setCancelled(true);
    }

    private class ComboPost1_14Listener
    implements Listener {
        private ComboPost1_14Listener() {
        }

        @EventHandler
        public void on(EntityDamageByEntityEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(player);
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            KitOptionsListener.this.plugin.doSyncAfter(() -> player.setNoDamageTicks(0), 1L);
        }
    }

    private class ComboPre1_14Listener
    implements Listener {
        private ComboPre1_14Listener() {
        }

        @EventHandler
        public void on(MatchStartEvent event) {
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(event.getMatch().getArena().getName());
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            for (Player player : event.getPlayers()) {
                MetadataUtil.put(KitOptionsListener.this.plugin, (Entity)player, KitOptionsListener.METADATA_KEY, player.getMaximumNoDamageTicks());
                player.setMaximumNoDamageTicks(0);
            }
        }

        @EventHandler
        public void on(MatchEndEvent event) {
            ArenaImpl arena = KitOptionsListener.this.arenaManager.get(event.getMatch().getArena().getName());
            if (arena == null || !KitOptionsListener.this.isEnabled(arena, KitImpl.Characteristic.COMBO)) {
                return;
            }
            MatchImpl match = arena.getMatch();
            if (match == null) {
                return;
            }
            match.getAllPlayers().forEach(player -> {
                Object value = MetadataUtil.removeAndGet(KitOptionsListener.this.plugin, (Entity)player, KitOptionsListener.METADATA_KEY);
                if (value == null) {
                    return;
                }
                player.setMaximumNoDamageTicks(((Integer)value).intValue());
            });
        }
    }
}

