/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.listeners;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.util.Log;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.compat.Identifiers;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class KitItemListener
implements Listener {
    private static final String WARNING = StringUtil.color("&4[Duels] Kit contents cannot be used when not in a duel.");
    private static final String WARNING_CONSOLE = "%s has attempted to use a kit item while not in duel, but was prevented by KitItemListener.";
    private final ArenaManagerImpl arenaManager;

    public KitItemListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        if (plugin.getConfiguration().isProtectKitItems()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    private boolean isExcluded(Player player) {
        return player.isOp() || player.hasPermission("duels.admin") || this.arenaManager.isInMatch(player);
    }

    private boolean isKitItem(ItemStack item) {
        return item != null && item.getType() != Material.AIR && Identifiers.hasIdentifier(item);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.isExcluded(player)) {
            return;
        }
        Inventory clicked = event.getClickedInventory();
        if (!(clicked instanceof PlayerInventory)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!this.isKitItem(item)) {
            return;
        }
        event.setCurrentItem(null);
        player.sendMessage(WARNING);
        Log.warn(String.format(WARNING_CONSOLE, player.getName()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.isExcluded(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (!this.isKitItem(item)) {
            return;
        }
        event.setCancelled(true);
        player.getInventory().remove(item);
        player.sendMessage(WARNING);
        Log.warn(String.format(WARNING_CONSOLE, player.getName()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        if (this.isExcluded(player)) {
            return;
        }
        Item item = event.getItem();
        if (!this.isKitItem(item.getItemStack())) {
            return;
        }
        event.setCancelled(true);
        item.remove();
        player.sendMessage(WARNING);
        Log.warn(String.format(WARNING_CONSOLE, player.getName()));
    }
}

