/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.listeners;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.match.MatchStartEvent;
import me.realized.duels.arena.ArenaManagerImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class EnderpearlListener
implements Listener {
    private static final long PEARL_EXPIRY = 60000L;
    private final ArenaManagerImpl arenaManager;
    private final Multimap<UUID, Pearl> pearls = HashMultimap.create();

    public EnderpearlListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void removeExpired(Player player) {
        Collection pearls = (Collection)this.pearls.asMap().get(player.getUniqueId());
        if (pearls == null || pearls.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        pearls.removeIf(pearl -> now - ((Pearl)pearl).creation > 60000L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void on(ProjectileLaunchEvent event) {
        if (event.getEntityType() != EntityType.ENDER_PEARL) {
            return;
        }
        EnderPearl enderPearl = (EnderPearl)event.getEntity();
        if (!(enderPearl.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)enderPearl.getShooter();
        if (this.arenaManager.isInMatch(player)) {
            return;
        }
        this.removeExpired(player);
        this.pearls.put((Object)player.getUniqueId(), (Object)new Pearl(enderPearl));
    }

    @EventHandler
    public void on(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof EnderPearl)) {
            return;
        }
        EnderPearl enderPearl = (EnderPearl)event.getEntity();
        if (!(enderPearl.getShooter() instanceof Player)) {
            return;
        }
        Collection pearls = (Collection)this.pearls.asMap().get(((Player)enderPearl.getShooter()).getUniqueId());
        if (pearls == null || pearls.isEmpty()) {
            return;
        }
        Iterator iterator = pearls.iterator();
        while (iterator.hasNext()) {
            Pearl pearl = (Pearl)iterator.next();
            if (!enderPearl.equals(pearl.pearl.get())) continue;
            iterator.remove();
            break;
        }
    }

    @EventHandler
    public void on(MatchStartEvent event) {
        for (Player player : event.getPlayers()) {
            Collection pearls = (Collection)this.pearls.asMap().remove(player.getUniqueId());
            if (pearls == null || pearls.isEmpty()) continue;
            pearls.forEach(pearl -> {
                EnderPearl enderPearl = (EnderPearl)((Pearl)pearl).pearl.get();
                if (enderPearl != null && !enderPearl.isDead()) {
                    enderPearl.remove();
                }
            });
        }
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.pearls.asMap().remove(event.getPlayer().getUniqueId());
    }

    private static class Pearl {
        private final long creation = System.currentTimeMillis();
        private final WeakReference<EnderPearl> pearl;

        public Pearl(EnderPearl pearl) {
            this.pearl = new WeakReference<EnderPearl>(pearl);
        }
    }
}

