/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.listeners;

import me.realized.duels.DuelsPlugin;
import me.realized.duels.arena.ArenaImpl;
import me.realized.duels.arena.ArenaManagerImpl;
import me.realized.duels.util.EventUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DamageListener
implements Listener {
    private final ArenaManagerImpl arenaManager;

    public DamageListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        if (plugin.getConfiguration().isForceAllowCombat()) {
            plugin.doSyncAfter(() -> Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin), 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent event) {
        if (!event.isCancelled() || !(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Player damager = EventUtil.getDamager(event);
        if (damager == null) {
            return;
        }
        ArenaImpl arena = this.arenaManager.get(player);
        if (arena == null || !this.arenaManager.isInMatch(damager) || arena.isEndGame()) {
            return;
        }
        event.setCancelled(false);
    }
}

