/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.kit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.kit.KitCreateEvent;
import me.realized.duels.api.event.kit.KitRemoveEvent;
import me.realized.duels.api.kit.Kit;
import me.realized.duels.api.kit.KitManager;
import me.realized.duels.config.Config;
import me.realized.duels.config.Lang;
import me.realized.duels.data.KitData;
import me.realized.duels.kit.KitImpl;
import me.realized.duels.util.Loadable;
import me.realized.duels.util.Log;
import me.realized.duels.util.StringUtil;
import me.realized.duels.util.compat.Items;
import me.realized.duels.util.gui.MultiPageGui;
import me.realized.duels.util.inventory.ItemBuilder;
import me.realized.duels.util.io.FileUtil;
import me.realized.duels.util.json.JsonUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitManagerImpl
implements Loadable,
KitManager {
    private static final String FILE_NAME = "kits.json";
    private static final String ERROR_NOT_ALPHANUMERIC = "Could not load kit %s: Name is not alphanumeric.";
    private static final String KITS_LOADED = "Loaded %s kit(s).";
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final File file;
    private final Map<String, KitImpl> kits = new LinkedHashMap<String, KitImpl>();
    private MultiPageGui<DuelsPlugin> gui;

    public KitManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.file = new File(plugin.getDataFolder(), FILE_NAME);
    }

    @Override
    public void handleLoad() throws IOException {
        this.gui = new MultiPageGui<DuelsPlugin>(this.plugin, this.lang.getMessage("GUI.kit-selector.title"), this.config.getKitSelectorRows(), this.kits.values());
        this.gui.setSpaceFiller(Items.from(this.config.getKitSelectorFillerType(), this.config.getKitSelectorFillerData()));
        this.gui.setPrevButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.previous-page.name")).build());
        this.gui.setNextButton(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.next-page.name")).build());
        this.gui.setEmptyIndicator(ItemBuilder.of(Material.PAPER).name(this.lang.getMessage("GUI.kit-selector.buttons.empty.name")).build());
        this.plugin.getGuiListener().addGui(this.gui);
        if (FileUtil.checkNonEmpty(this.file, true)) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8);){
                Map data = JsonUtil.getObjectMapper().readValue((Reader)reader, new TypeReference<LinkedHashMap<String, KitData>>(){});
                if (data != null) {
                    for (Map.Entry entry : data.entrySet()) {
                        if (!StringUtil.isAlphanumeric((String)entry.getKey())) {
                            Log.warn(this, String.format(ERROR_NOT_ALPHANUMERIC, entry.getKey()));
                            continue;
                        }
                        this.kits.put((String)entry.getKey(), ((KitData)entry.getValue()).toKit(this.plugin));
                    }
                }
            }
        }
        Log.info(this, String.format(KITS_LOADED, this.kits.size()));
        this.gui.calculatePages();
    }

    @Override
    public void handleUnload() {
        if (this.gui != null) {
            this.plugin.getGuiListener().removeGui(this.gui);
        }
        this.kits.clear();
    }

    void saveKits() {
        LinkedHashMap<String, KitData> data = new LinkedHashMap<String, KitData>();
        for (Map.Entry<String, KitImpl> entry : this.kits.entrySet()) {
            data.put(entry.getKey(), KitData.fromKit(entry.getValue()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charsets.UTF_8);){
            JsonUtil.getObjectWriter().writeValue(writer, data);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            Log.error(this, ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public KitImpl get(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        return this.kits.get(name);
    }

    public KitImpl create(@NotNull Player creator, @NotNull String name, boolean override) {
        Objects.requireNonNull(creator, "creator");
        Objects.requireNonNull(name, "name");
        if (!StringUtil.isAlphanumeric(name) || !override && this.kits.containsKey(name)) {
            return null;
        }
        KitImpl kit = new KitImpl(this.plugin, name, creator.getInventory());
        this.kits.put(name, kit);
        this.saveKits();
        KitCreateEvent event = new KitCreateEvent(creator, (Kit)kit);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return kit;
    }

    @Override
    @Nullable
    public KitImpl create(@NotNull Player creator, @NotNull String name) {
        return this.create(creator, name, false);
    }

    @Override
    @Nullable
    public KitImpl remove(@Nullable CommandSender source, @NotNull String name) {
        Objects.requireNonNull(name, "name");
        KitImpl kit = this.kits.remove(name);
        if (kit == null) {
            return null;
        }
        kit.setRemoved(true);
        this.plugin.getArenaManager().clearBinds(kit);
        this.saveKits();
        KitRemoveEvent event = new KitRemoveEvent(source, kit);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gui.calculatePages();
        return kit;
    }

    @Override
    @Nullable
    public KitImpl remove(@NotNull String name) {
        return this.remove(null, name);
    }

    @Override
    @NotNull
    public List<Kit> getKits() {
        return Collections.unmodifiableList(Lists.newArrayList(this.kits.values()));
    }

    public List<String> getNames(boolean nokit) {
        ArrayList<String> names = new ArrayList<String>(this.kits.keySet());
        if (nokit) {
            names.add("-");
        }
        return names;
    }

    public MultiPageGui<DuelsPlugin> getGui() {
        return this.gui;
    }
}

