/*
 * Decompiled with CFR 0.152.
 */
package me.realized.duels.kit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.realized.duels.DuelsPlugin;
import me.realized.duels.api.event.kit.KitEquipEvent;
import me.realized.duels.api.kit.Kit;
import me.realized.duels.gui.BaseButton;
import me.realized.duels.setting.Settings;
import me.realized.duels.util.inventory.InventoryUtil;
import me.realized.duels.util.inventory.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class KitImpl
extends BaseButton
implements Kit {
    private final String name;
    private final Map<String, Map<Integer, ItemStack>> items = new HashMap<String, Map<Integer, ItemStack>>();
    private boolean usePermission;
    private boolean arenaSpecific;
    private Set<Characteristic> characteristics;
    private boolean removed;

    public KitImpl(DuelsPlugin plugin, String name, ItemStack displayed, boolean usePermission, boolean arenaSpecific, Set<Characteristic> characteristics) {
        super(plugin, displayed != null ? displayed : ItemBuilder.of(Material.DIAMOND_SWORD).name("&7&l" + name).lore("&aClick to send", "&aa duel request", "&awith this kit!").build());
        this.name = name;
        this.usePermission = usePermission;
        this.arenaSpecific = arenaSpecific;
        this.characteristics = characteristics;
    }

    public KitImpl(DuelsPlugin plugin, String name, PlayerInventory inventory) {
        this(plugin, name, null, false, false, new HashSet<Characteristic>());
        InventoryUtil.addToMap(inventory, this.items);
    }

    @Override
    @NotNull
    public ItemStack getDisplayed() {
        return super.getDisplayed();
    }

    @Override
    public void setDisplayed(ItemStack displayed) {
        super.setDisplayed(displayed);
        this.kitManager.saveKits();
    }

    public boolean hasCharacteristic(Characteristic characteristic) {
        return this.characteristics.contains((Object)characteristic);
    }

    public void toggleCharacteristic(Characteristic characteristic) {
        if (this.hasCharacteristic(characteristic)) {
            this.characteristics.remove((Object)characteristic);
        } else {
            this.characteristics.add(characteristic);
        }
        this.kitManager.saveKits();
    }

    @Override
    public void setUsePermission(boolean usePermission) {
        this.usePermission = usePermission;
        this.kitManager.saveKits();
    }

    @Override
    public void setArenaSpecific(boolean arenaSpecific) {
        this.arenaSpecific = arenaSpecific;
        this.kitManager.saveKits();
    }

    @Override
    public boolean equip(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        KitEquipEvent event = new KitEquipEvent(player, (Kit)this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        InventoryUtil.fillFromMap(player.getInventory(), this.items);
        player.updateInventory();
        return true;
    }

    @Override
    public void onClick(Player player) {
        String permission = String.format("duels.kits.%s", this.name.replace(" ", "-").toLowerCase());
        if (this.usePermission && !player.hasPermission("duels.kits.*") && !player.hasPermission(permission)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", permission);
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        if (settings.getArena() != null && !this.arenaManager.isSelectable(this, settings.getArena())) {
            this.lang.sendMessage((CommandSender)player, "ERROR.setting.arena-not-applicable", "kit", this.name, "arena", settings.getArena().getName());
            return;
        }
        settings.setKit(this);
        settings.openGui(player);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KitImpl kit = (KitImpl)other;
        return Objects.equals(this.name, kit.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, Map<Integer, ItemStack>> getItems() {
        return this.items;
    }

    @Override
    public boolean isUsePermission() {
        return this.usePermission;
    }

    @Override
    public boolean isArenaSpecific() {
        return this.arenaSpecific;
    }

    public Set<Characteristic> getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public static enum Characteristic {
        SOUP,
        SUMO,
        UHC,
        COMBO;

    }
}

